package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 批量出口转内销海关缴款书信息查询
 */
public class PostExportToDomesticSalesCustomsPaymentMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 归集日期起
         * 长度：8
         * YYYYMMDD 数据归集起止日期不能跨月
         */
        @JSONField(name = "sjgjrqq")
        private String startDateCollect;

        /**
         * 归集日期
         * 长度：8
         * YYYYMMDD 数据归集起止 日期不能跨月
         */
        @JSONField(name = "sjgjrqz")
        private String endDateCollect;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 总数量
         * 长度：10
         */
        @JSONField(name = "count")
        private String count;

        @JSONField(name = "jksmx")
        private List<Invoice> invoiceList;

        @Data
        public static class Invoice {

            /**
             * 海关缴款书号码
             * 长度：20
             */
            @JSONField(name = "hgjkshm")
            private String customsPaymentNo;

            /**
             * 填发日期
             * 格式：
             * yyyy-MM-dd HH:mm:ss
             */
            // @NotNull 赋码之前为空
            @JSONField(name = "tfrq")
            private String dateTimeIssued;

            /**
             * 出口转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesNo;

            /**
             * 缴款单位(人)纳税人识别号
             */
            @JSONField(name = "jkdwrnsrsbh")
            private String paymentTaxNo;

            /**
             * 税款金额
             * 最大长度18位，最多2位小数。
             */
            @JSONField(name = "skje")
            private BigDecimal taxAmount;
        }
    }
}
