package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 批量出口转内销发票信息查询
 */
public class PostExportToDomesticSalesInvoiceMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 归集日期起
         * 长度：8
         * YYYYMMDD 数据归集起止日期不能跨月
         */
        @JSONField(name = "sjgjrqq")
        private String startDateCollect;

        /**
         * 归集日期
         * 长度：8
         * YYYYMMDD 数据归集起止 日期不能跨月
         */
        @JSONField(name = "sjgjrqz")
        private String endDateCollect;

        /**
         * 发票类型
         * 长度：2
         * 01:增值税专用发票
         * 08:增值税电子专用发票
         * 81:电子发票(增值税专用发票)
         * 85:纸质发票(增值税专用发票)
         * */
        @JSONField(name = "fplx")
        private String invoiceType;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 总数量
         * 长度：10
         */
        @JSONField(name = "count")
        private String count;

        @JSONField(name = "fpmx")
        private List<Invoice> invoiceList;

        @Data
        public static class Invoice {
            /**
             * 数字化电子发票发票代码可为空
             * 长度：12
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 数字化电子发票，发票号码20位
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 开票日期
             * 格式：
             * yyyy-MM-dd HH:mm:ss
             */
            // @NotNull 赋码之前为空
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 出口转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesNo;

            /**
             * 销方纳税人识别号
             */
            @JSONField(name = "xsfnsrsbh")
            private String sellerTaxNo;

            /**
             *购方纳税人识别号
             */
            @JSONField(name = "gmfnsrsbh")
            private String buyerTaxNo;

            /**
             * 金额
             * 最大长度18位，最多2位小数。
             */
            @JSONField(name = "je")
            private BigDecimal amountWithoutTax;

            /**
             * 税额
             */
            @JSONField(name = "se")
            private BigDecimal taxAmount;
        }
    }
}
