package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 全电发票xml文件下载结果
 *
 * @author zhouwen
 * @date 2023-03-08 17:45
 */
public class PostInvoiceXmlDownloadResultMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         * 必填
         */
        @JSONField(name = "lsh")
        private String taskId;

        /**
         * 包号
         * 数据包号，当数据量过大时会进行分包处理,初始包号为1
         * 必填
         */
        @JSONField(name = "packageno")
        private String packageNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 总包数
         * 当前流水号下的总包数
         */
        @JSONField(name = "packagecount")
        private String total;

        /**
         * 发票反馈明细信息
         */
        @JSONField(name = "fpfkmxxx")
        private List<Detail> detailList;

        @Data
        public static class Detail {

            /**
             * 发票号码
             * 非必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 发票代码
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 开票日期
             * 格式: yyyy-MM-dd HH:mm:ss
             * 非必填
             */
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 销售方识别号
             * 非必填
             */
            @JSONField(name = "xsfsbh")
            private String sellerTaxNo;

            /**
             * 购买方识别号
             * 非必填
             */
            @JSONField(name = "gmfsbh")
            private String buyerTaxNo;

            /**
             * 处理结果
             * 1-成功
             * 2-不存在符合条件的发票
             * 3-失败
             * 必填
             */
            @JSONField(name = "cljg")
            private String returnCode;

            /**
             * 数据流
             * 压缩包文件流（zip+base64）
             * 非必填
             */
            @JSONField(name = "sjl")
            private String returnData;
        }
    }
}
