package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 申请注销勾选
 */
public class PostCancelCheck {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 申请标志
         * 长度：1
         * 必需
         * 1：申请注销勾选
         * 2：撤销注销勾选
         */
        @JSONField(name = "sqbz")
        private String applyFlag;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
    }
}
