package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 查询申请统计处理结果
 */
public class PostDeductionStatisticsApplyResult {
    @Data
    public static class Request {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 税款所属期
         * 格式 YYYYMM， 抵扣成功时该
         * 字段不为空
         * 长度：6
         * 必需
         */
        @JSONField(name = "skssq")
        private String taxPeriod;

        /**
         * 处理结果
         * 长度：2
         * 必填
         * 01：处理成功（统计、撤销）
         * 02：重复申请统计
         * 03：当期已确认，不可统计
         * 04：税号不存在
         * 05：未申请统计不能撤销
         * 06：已申报不能撤销统计
         * 10：已确认统计不能撤销
         * 99：其他异常
         */
        @JSONField(name = "code")
        private String returnStatus;

        @JSONField(name = "gxtjjg")
        private List<StatisticsResultGxtjjg> statisticsResultGxtjjg;

        @Data
        public static class StatisticsResultGxtjjg {

            /**
             * 购买方统一社会信用代码/纳税人识别号
             * 长度：30
             * 必需
             */
            @JSONField(name = "gfsbh")
            private String taxNo;
            /**
             * 统计时间
             * 长度：19
             * 必需
             * YYYY-MM-DD HH:mm:ss
             */
            @JSONField(name = "tjsj")
            private String statisticsTime;

            /**
             * 统计结果（json）
             * 必需
             */
            @JSONField(name = "tjjg")
            private List<StatisticsResult> statisticsResultList;

            /**
             * 农产品加计扣除统计结果（json）
             * 必需
             */
            @JSONField(name = "ncpjjkctjjg")
            private List<FarmProduceDeductionStatisticsResult> farmProduceDeductionStatisticsResultList;

            /**
             * 异常凭证转入统计结果（json）
             * 必需
             */
            @JSONField(name = "ycpzzrtjjg")
            private List<StatisticsResult> abnormalProofStatisticsResultList;

            /**
             * 异常凭证农产品加计扣除转入统计结果（json）
             * 必需
             */
            @JSONField(name = "ycpzncpjjkczrtjjg")
            private List<AbnormalProofFarmProduceDeductionStatisticsResult> abnormalProofFarmProduceDeductionStatisticsResultList;


        }

        @Data
        public static class StatisticsResult {
            /**
             * 发票类型
             * 0：增值税专用发票
             * 1：收购发票
             * 2：免税自产农产品普通发票
             * 3：通行费发票
             * 4：其他普通发票
             * 5：机动车统一销售发票
             * 6：海关缴款书
             * 7：代扣代缴完税凭证
             * 8：总计
             * 21：航空运输客票电子行程单
             * 22：铁路电子客票
             */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 合计份数
             */
            @JSONField(name = "hjfs")
            private String invoiceCount;

            /**
             * 有效抵扣税额合计
             */
            @JSONField(name = "hjyxdkse")
            private String effectiveTaxAmount;

            /**
             * 出口转内销证明份数
             */
            @JSONField(name = "ckznxzmfs")
            private String exportToDomesticSalesCount;

            /**
             * 出口转内销有效抵扣税额合计
             */
            @JSONField(name = "ckznxzmyxdkse")
            private String exportToDomesticEffectiveTaxAmount;

            /**
             * 其他发票份数
             */
            @JSONField(name = "qtfpfs")
            private String otherInvoiceCount;

            /**
             * 其他发票有效抵扣税额合计
             */
            @JSONField(name = "qtfpyxdkse")
            private String otherInvoiceEffectiveTaxAmount;
        }

        @Data
        public static class FarmProduceDeductionStatisticsResult {
            /**
             * 发票类型
             * 9：增值税专用发票
             * 10：收购发票
             * 11：免税自产农产品普通发票
             * 12：海关缴款书
             * 13：录入本期有效抵扣税额
             * 14：合计
             */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 正数发票份数
             */
            @JSONField(name = "zsfpfs")
            private String blueCount;

            /**
             * 正数发票税额
             */
            @JSONField(name = "zsfpse")
            private String blueTaxAmount;

            /**
             * 负数发票份数
             */
            @JSONField(name = "fsfpfs")
            private String redCount;

            /**
             * 负数发票税额
             */
            @JSONField(name = "fsfpse")
            private String redTaxAmount;
        }

        @Data
        public static class AbnormalProofFarmProduceDeductionStatisticsResult {
            /**
             * 发票类型
             * 9：增值税专用发票
             * 10：收购发票
             * 11：免税自产农产品普通发票
             * 12：海关缴款书
             * 13：录入本期有效抵扣税额
             * 14：合计
             */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 正数发票份数
             */
            @JSONField(name = "zsfpfs")
            private String blueCount;

            /**
             * 正数发票税额
             */
            @JSONField(name = "zsfpse")
            private String blueTaxAmount;
        }
    }
}
