package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 查询确认统计处理结果
 */
public class PostDeductionStatisticsConfirmApplyResult {
    @Data
    public static class Request {

        /**
         * 批次流水号
         * 长度：30
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 当前统计确认状态
         * 长度：2
         * 必需
         * 01：处理成功（统计、撤销）
         * 07：确认失败，未申请统计
         * 08：确认失败，不能重复确认
         * 04：税号不存在
         * 09：不符合确认条件（当前月与属期相等时）
         * 10：已确认统计不能撤销（备注：不能直接撤销已统计数据，需要先撤销确认申请）
         */
        @JSONField(name = "jgzt")
        private String statisticsStatusConfirm;

        /**
         * 发票异常信息 fpycxx
         * 存在异常发票信息时记录数据
         */
        @JSONField(name = "fpycxx")
        private List<ErrorDetail> errorDetailList;

        /**
         * 海关缴款书异常信息 hgjksycxx
         * 存在异常发票信息时记录数据
         */
        @JSONField(name = "hgjksycxx")
        private List<CustomsPaymentErrorDetail> customsPaymentErrorDetailList;

        @Data
        public static class ErrorDetail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 非必需
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必需
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 非必需
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 购买方统一社会 信用代码/纳税 人识别号
             * 长度：30
             * 非必需
             * 纳税人识别 号/总、分支 机构纳税人 识别号
             */
            @JSONField(name = "gfsbh")
            private String buyerTaxNo;

            /**
             * 税款所属期
             * YYYYMM
             * 长度：6
             * 非必需
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 发票状态
             * 长度：1
             * 非必需
             * 0：正常
             * 1：失控
             * 2：作废
             * 3：已红冲
             * 7：部分冲红
             * 8：全额红冲
             */
            @JSONField(name = "fpzt")
            private String status;

            /**
             * 是否异常凭证
             * 长度：2
             * 非必填
             * 01：正常
             * 02：异常凭证
             * 03：疑似异常凭证
             */
            @JSONField(name = "sfycpz")
            private String abnormalStatus;

            /**
             * 锁定状态
             * 长度：2
             * 非必需
             * 01：未锁定
             * 02：已锁定
             */
            @JSONField(name = "sdzt")
            private String blockStatus;
        }

        @Data
        public static class CustomsPaymentErrorDetail {
            /**
             * 缴款书号码
             * 长度：22
             * 非必需
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 填发日期
             * 长度：8
             * 非必需
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 缴款单位(人)纳税人识别号
             */
            @JSONField(name = "jkdwrnsrsbh")
            private String paymentTaxNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必需
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 税款所属期
             * 长度：6
             * 非必需
             * YYYYMM
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 是否重号锁定
             * 长度：1
             * 非必需
             * Y:锁定 N:未锁定
             */
            @JSONField(name = "sfchsd")
            private String blockStatus;
        }
    }
}
