package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 汇总纳税人机构列表查询
 */
public class PostSummaryTaxpayer {
    @Data
    public static class Request {
        /**
         * 购方纳税人识别号/统一社会信用代码
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 总数量
         * 非必填
         * 有数据时返回
         */
        @JSONField(name = "zsl")
        private Integer total;

        @JSONField(name = "hznsrjglb")
        private List<Detail> taxRateList;

        @Data
        public static class Detail {
            /**
             * 购方纳税人识别号/统一社会信用代码
             * 长度：30
             * 必需
             */
            @JSONField(name = "nsrsbh")
            private String taxNo;

            /**
             * 纳税人名称
             */
            @JSONField(name = "nsrmc")
            private String taxpayerName;
        }
    }
}
