package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 申请税款所属期变更
 */
public class PostTaxPeriodChange {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 变更属期
         * 长度：6
         * 必填
         * 申请变更到的税款所属期
         * YYYYMM
         */
        @JSONField(name = "bgsq")
        private String changePeriod;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 是否属期变更成功
         * 长度：2
         * 必填
         * 01：成功
         * 02：失败
         */
        @JSONField(name = "sfbgcg")
        private String changeStatus;

        /**
         * 错误信息
         * 长度：2000
         * 非必填是否属期变更成功为 02：失败时记录失败原因
         */
        @JSONField(name = "errormsg")
        private String errorMsg;

        /**
         * 变更属期
         * 长度：6
         * 非必填
         * 是否属期变更成功为 01：成功时返回已成功变更的税款所属期
         * YYYYMM
         */
        @JSONField(name = "bgsq")
        private String changePeriod;
    }
}
