package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deputy;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 未勾选数据初始化清单下载申请-代办退税
 */
public class PostDeputyTaxRefundUncheckInit {
    @Data
    public static class Request {
        /**
         * 购方纳税人识别号/统一社会信用代码
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String buyerTaxNo;

        /**
         * 业务类型
         * 长度：2
         * 必需
         * 04：代办退税业务
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 凭证种类
         * 长度：2
         * 必需
         * 01：发票
         */
        @JSONField(name = "pzzl")
        private String proofType;

        /**
         * 起始开票月份
         * 长度：6
         * 非必需
         * 申请下载起始开票月份至当前自然月如未传入则查询近三月
         * YYYYMM
         */
        @JSONField(name = "kpyf")
        private String startDate;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号
         * 长度：32
         * 非必需
         * 返回码不是 00：成功时，不返回
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
