package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lv
 * @date 2023/10/11
 * @describe: 查询建筑服务信息
 */
public class PostBuildingServiceInfoMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 开票纳税人识别号/统一社会信用代码
         * 20
         * 是
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 省级税务机关代码
         * 11
         * 是
         */
        @JSONField(name = "sjswjgdm")
        private String provincialTaxAuthorityCode;

        /**
         * 项目编号 16
         * 是
         */
        @JSONField(name = "xmbh")
        private String landVatItemNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 纳税人识别号
         * 20
         * 是
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 建筑服务发生地
         * varchar
         * 120
         * 是
         * 建筑服务发生 地县(市、区) 名称
         */
        @JSONField(name = "jzfwfsd")
        private String place;

        /**
         * 建筑项目名称
         * varchar
         * 80
         * 是
         */
        @JSONField(name = "jzxmmc")
        private String entryName;

        /**
         * 项目编号
         * varchar
         * 16
         * 是
         * 为房地产企业
         * 建设房产需要
         * 填写
         */
        @JSONField(name = "xmbh")
        private String landVatItemNo;
    }
}
