package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 给企业提供调整授信额度有效期接口，企业在月初未申报时下载的授信额度的有效期止为当月申报截止日期
 * 超过授信额度有效期止后，无法开具数字化电子发票
 * 企业在完成申报或到达授信额度有效期止后，通过此接口调整授信额度有效期，并根据税局端返回的有效期更新本地授信额度有效期。
 *
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 调整授信额度有效期
 */
public class PostCreditLinePeriodMessage {

    @Data
    public static class Request {

        /**
         * 统一社会信用代码/纳税人识别号/身份证件号码
         */
        @JSONField(name = "xsfnsrsbh")
        private String taxNo;

        /**
         * 授信额度属期
         * 格式：yyyy-MM
         */
        @JSONField(name = "sxedsq")
        private String period;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 授信额度属期
         * 格式：yyyy-MM
         */
        @JSONField(name = "sxedsq")
        private String period;

        /**
         * 授信额度使用区间起（非必须）
         * 下载授信额度时，有此节点
         * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
         */
        @JSONField(name = "syqjq")
        private String startCreditLineDate;

        /**
         * 授信额度使用区间止（非必须）
         * 下载授信额度时，有此节点
         * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
         */
        @JSONField(name = "syqjz")
        private String endCreditLineDate;
    }

}
