package com.xforceplus.taxware.leqi.kernel.contract.model.seller.style;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @Auther lv
 * @Date 2023/10/11
 * @Description 不动产销售特殊要素信息
 */
@Data
public class RealEstateSales {

    /**
     * 不动产单位代码
     * varchar
     * 28
     * 否
     * “不动产单位 代码”和“网签 合同备案编 号”两者只能 填一个
     */
    @JSONField(name = "bdcdwdm")
    private String realEstateCode;

    /**
     * 网签合同备案编 号
     * varchar
     * 28
     * 否
     * “不动产单位 代码”和“网签 合同备案编 号”两者只能 填一个
     */
    @JSONField(name = "wqhtbabh")
    private String contractNo;

    /**
     * 不动产坐落地址
     * varchar
     * 120
     * 是
     * 必须包含街、 路、村、乡、 镇、道、巷、 号等任意一个 关键词
     */
    @JSONField(name = "bdczldz")
    private String landVatItemAddress;

    /**
     * 土地增值税项目 编号
     * varchar
     * 16
     * 否
     */
    @JSONField(name = "tdzzsxmbh")
    private String landVatItemNo;

    /**
     * 跨地(市)标志
     * varchar
     * 1
     * 是
     * Y是N否
     */
    @JSONField(name = "kdsbz")
    private String crossCitySign;

    /**
     * 核定计税价格
     * number
     * 18,2
     * 否
     * 不属于核定计税不动产销售的可不填写
     */
    @JSONField(name = "hdjsjg")
    private String taxablePrice;

    /**
     * 实际成交含税金 额
     * number
     * 18,2
     * 否
     * 若按核定计税价格征税的，为必填。
     */
    @JSONField(name = "sjcjhsje")
    private String transactionPrice;

    /**
     * 多方共同购买标 志
     * varchar
     * 1
     * 否
     * Y:多方共同 购买 N:非多方共 同购买
     */
    @JSONField(name = "dfgtgmbz")
    private String multipartiteFlag;

    /**
     * 共同购买方
     * varchar
     * 20
     * 否
     */
    @JSONField(name = "gtgmf")
    private String buyerName;

    /**
     * 证件类型
     * varchar
     * 3
     * 否
     */
    @JSONField(name = "zjlx")
    private String buyerIdentityType;

    /**
     * 证件号码
     * varchar
     * 20
     * 否
     */
    @JSONField(name = "zjhm")
    private String buyerNo;

}
