package com.xforceplus.taxware.leqi.kernel.contract.model.base.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/18
 * @Description 增值税发票数据
 *
 *      01：增值税专用发票
 *      02：货物运输业增值税专用发票
 *      04：增值税普通发票
 *      08：增值税电子专用发票
 *      10：增值税电子普通发票
 */
@Data
public class InvoiceVat {

    /**
     * 发票代码
     * 长度：12
     * 非必需
     */
    @JSONField(name = "fpdm")
    private String invoiceCode;

    /**
     * 发票号码
     * 长度：20
     * 必需
     */
    @JSONField(name = "fphm")
    private String allElectricInvoiceNo;

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     * 长度：19
     * 必需
     */
    @JSONField(name = "kprq")
    private String dateTimeIssued;

    /**
     * 特殊票种
     * 长度：2
     * 非必需
     * 02：农产品收购
     * 03：稀土矿产品发票
     * 04：稀土产 成品发票
     * 05：石脑油
     * 08：成品油发票；
     */
    @JSONField(name = "tspz")
    private String specialType;

    /**
     * 发票状态标识
     * 长度：1
     * 必需
     * 0：正数票
     * 1：负数票
     * 2：空白作废发票
     * 3：正数作废发票
     * 4：负数作废发票
     */
    @JSONField(name = "fpztbz")
    private String status;

    /**
     * 校验码
     * 长度：32
     * 非必需
     */
    @JSONField(name = "jym")
    private String checkCode;

    /**
     * 销售方识别号
     * 长度：20
     * 必需
     */
    @JSONField(name = "xsfsbh")
    private String sellerTaxNo;

    /**
     * 销售方名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xsfmc")
    private String sellerName;

    /**
     * 购买方税号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gmfsbh")
    private String buyerTaxNo;

    /**
     * 购买方名称
     * 长度：300
     * 必需
     */
    @JSONField(name = "gmfmc")
    private String buyerName;


    /**
     * 代开发票真实销售方识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "dkXsfsbh")
    private String deputySellerTaxNo;

    /**
     * 代开发票真实销售方名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "dkXsfmc")
    private String deputySellerName;

    /**
     * 作废日期
     * 长度：19
     * 非必需
     * YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "zfrq")
    private String cancellationTime;

    /**
     * 金额
     * 必需
     */
    @JSONField(name = "je")
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 必需
     */
    @JSONField(name = "se")
    private BigDecimal taxAmount;

    /**
     * 税率
     * 必需
     */
    @JSONField(name = "slv")
    private BigDecimal taxRate;

    /**
     * 价税合计
     * 必需
     */
    @JSONField(name = "jshj")
    private BigDecimal amountWithTax;

    /**
     * 备注
     * 长度：450
     * 非必需
     */
    @JSONField(name = "bz")
    private String remark;

    /**
     * 开具类型（代开标识）
     * 长度：1
     * 必需
     * 1：自开
     * 2：代开
     * 3：代办退税
     */
    @JSONField(name = "kjlx")
    private String issuedType;

    /**
     * 含税税率标识
     * 长度：1
     * 非必需
     * 0：不含税税率
     * 1：含税税率
     * 2：差额征税
     */
    @JSONField(name = "hsslbz")
    private String taxRateFlag;

    /**
     * 适用税率标识
     * 长度：1
     * 必需
     * 0：不是
     * 1：是
     * 其他：不是
     */
    @JSONField(name = "syslbs")
    private String applyTaxRateFlag;

    /**
     * 明细条数
     * 长度：20
     * 非必需
     */
    @JSONField(name = "mxts")
    private Integer detailCount;

    /**
     * 不征税金额
     * 非必需
     */
    @JSONField(name = "bzsje")
    private BigDecimal amountNonTaxation;

    /**
     * 销售方地址电话
     * 长度：190
     * 非必需
     */
    @JSONField(name = "xsfdzdh")
    private String sellerAddressTelInfo;

    /**
     * 销售方银行账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "xsfyhzh")
    private String sellerBankInfo;

    /**
     * 购买方地址电话
     * 长度：190
     * 非必需
     */
    @JSONField(name = "gmfdzdh")
    private String buyerAddressTelInfo;

    /**
     * 购买方银行账号
     * 长度：300
     * 非必需
     */
    @JSONField(name = "gmfyhzh")
    private String buyerBankInfo;

    @JSONField(name = "hwxx")
    private List<Detail> detailList;

    @Data
    public static class Detail {
        /**
         * 货物明细序号
         * 长度：11
         * 必需
         */
        @JSONField(name = "mxxh")
        private Integer rowNum;

        /**
         * 货物名称
         * 长度：310
         * 非必需
         */
        @JSONField(name = "mc")
        private String itemName;

        /**
         * 规格型号
         * 长度：64
         * 非必需
         */
        @JSONField(name = "ggxh")
        private String specifications;

        /**
         * 计量单位
         * 长度：52
         * 非必需
         */
        @JSONField(name = "jldw")
        private String unit;

        /**
         * 数量
         * 长度：25
         * 非必需
         */
        @JSONField(name = "sl")
        private String quantity;

        /**
         * 单价
         * 长度：25
         * 必需
         */
        @JSONField(name = "dj")
        private String unitPrice;

        /**
         * 税率
         * 必需
         */
        @JSONField(name = "slv")
        private BigDecimal taxRate;

        /**
         * 税额
         * 必需
         */
        @JSONField(name = "se")
        private BigDecimal taxAmount;

        /**
         * 金额
         * 必需
         */
        @JSONField(name = "je")
        private BigDecimal amountWithoutTax;

        /**
         * 商品编码
         * 长度：45
         * 必需
         */
        @JSONField(name = "spbm")
        private String goodsTaxNo;
    }
}
