package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 获取当前税款所属期代扣代缴完税凭证抵扣勾选处理结果
 */
public class PostCurrentTaxPeriodVatTaxPaymentVoucherDeduction {
    @Data
    public static class Request {
        /**
         * 扣缴义务人识别号
         * 长度：30
         * 非必需
         */
        @JSONField(name = "kjywrsbh")
        private String taxNo;

        /**
         * 查询页码
         * int
         * 不传默认为 1，可根据返回的总页数调整所需要查询的页码数据
         */
        @JSONField(name = "cxym")
        private String pageNumber;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 总页数
         * int
         * 必需
         */
        @JSONField(name = "zys")
        private String totalPageCount;

        /**
         * 当前页码
         * int
         * 必需
         * 每页 200 条
         */
        @JSONField(name = "dqym")
        private String pageSize;

        @JSONField(name = "dkdjmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 填发日期
             * 长度：8
             * 必需
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 被扣缴义务人统一社会信用代码/纳税人识别号
             * 长度：30
             * 必需
             */
            @JSONField(name = "bkjnsrsbh")
            private String taxNo;

            /**
             * 代扣代缴完税凭证号
             * 长度：22
             * 必需
             */
            @JSONField(name = "dkdjwspzh")
            private String taxPaidProof;

            /**
             * 税款所属期
             * 格式YYYYMM，抵扣成功时该字段不为空
             * 长度：6
             * 非必填
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 勾选时间
             * 长度：8
             * 非必需
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 当前勾选用途
             * 长度：2
             * 非必需
             * 处理结果为06：已勾选无法重复勾选时，根据实际情况反馈此码值。
             * 1：已申请抵扣
             * 2：已申请退税
             * 3：已申请代办退税
             * 4：已勾选不抵扣（历史数据）
             * 5：已申请代办退税（历史数据）
             * 6：已申请不抵扣
             */
            @JSONField(name = "hxyt")
            private String deductionPurpose;
        }
    }
}
