package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 未勾选数据初始化清单下载申请
 */
public class PostDeductionUncheckInit {
    @Data
    public static class Request {
        /**
         * 购方纳税人识别号/统一社会信用代码
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 业务类型
         * 长度：2
         * 必需
         * 01：抵扣业务
         * 09：待处理农产品发票确认
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 凭证种类
         * 长度：2
         * 必需
         * 01：发票
         * 02：出口转内销发票
         * 03：海关缴款书
         * 04：出口转内销海关缴款书
         * 05：代扣代缴完税凭证
         */
        @JSONField(name = "pzzl")
        private String proofType;

        /**
         * 起始开票月份
         * 长度：6
         * 非必需
         * 申请下载起始 开票月份至当 前自然月 如未传入则查 询近三月
         * YYYYMM
         */
        @JSONField(name = "kpyf")
        private String startDate;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号
         * 长度：32
         * 非必需
         * 返回码不是 00：成功时，不返回
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
