package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 批量上传抵扣发票
 */
public class PostInvoiceDeductionUpload {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：20
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 勾选类型
         * 长度：2
         * 必需
         * 01.申请抵扣
         * 02.撤销抵扣
         * 03.申请不抵扣
         * 04.撤销不抵扣
         */
        @JSONField(name = "gxlxDm")
        private String deductionType;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 发票类型
             * 长度：2
             * 必填
             * 01：增值税专用发票
             * 03：机动车销售统一发票
             * 08：增值税电子专用发票
             * 14：通行费发票
             * 51-电子发票（铁路电子客票）
             * 61-电子发票（航空运输客票电子行程单）
             * 81：电子发票（增值税专用发票）
             * 82：电子发票（通行费发票）
             * 83：机动车销售电子统一发票
             * 85：纸质发票（增值税专用发票）
             * 87：纸质发票（机动车销售统一发票）
             * */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 不抵扣类型
             * 长度：2
             * 非必填
             * 申请勾选类型选择03：申请不抵扣时，需选择以下不抵扣类型
             * 1:用于非应税项目
             * 2:用于免税项目
             * 3:用于集体福利或者个人消费
             * 4:遭受非正常损失
             * 5:其他
             */
            @JSONField(name = "bdklx")
            private String unDeductionType;

            /**
             * 不抵扣原因
             * 长度：300
             * 非必填
             * 不抵扣类型选择为5:其他时，需要录入不抵扣原因
             */
            @JSONField(name = "bdkyy")
            private String unDeductionReason;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;

        @JSONField(name = "fpmx")
        private List<Detail> details;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 上传状态
             * 长度：2
             * 必需
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sczt")
            private String uploadStatus;

            /**
             * 错误码
             * 长度：2000
             * 非必须
             * 01：失败时记录失败原因
             */
            @JSONField(name = "errormsg")
            private String errorMsg;

        }
    }
}
