package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.entry;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvwenjing
 * @date 2023/11/15
 * @describe: 批量上传入账海关缴款书
 */
public class PostCustomsPaymentEntryUpload {

    @Data
    public static class Request {

        /**
         * 缴款单位人纳税人识别号
         * 长度：20
         */
        @JSONField(name = "jkdwrnsrsbh")
        private String taxNo;

        /**
         * 海关缴款书号码
         * 长度：75
         */
        @JSONField(name = "hgjkshm")
        private String customsPaymentNo;

        /**
         * 填发日期
         * 长度：8:YYYYMMDD
         */
        @JSONField(name = "tfrq")
        private String dateIssued;

        /**
         * 入账属期
         * 格式为：YYYYMM。当“申请勾选类型”为“02”,“03”,“04”,“05”时入账属期必填，“06”无需填写
         */
        @JSONField(name = "skssq")
        private String period;

        /**
         * 申请勾选类型
         * 02：入账（企业所得税税前扣除）
         * 03：入账（企业所得税不扣除）
         * 04：入账（个人所得税经营所得税前扣除）
         * 05：入账（个人所得税经营所得不扣除）
         * 06：入账撤销
         * 长度：1
         * 必填
         */
        @JSONField(name = "sqgxlx")
        private String deductionType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号
         * 长度：32
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
