package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.entry;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/11/15
 * @describe: 查询海关缴款书入账处理结果
 */
public class PostCustomsPaymentEntryUploadResult {

    @Data
    public static class Request {

        /**
         * 批次流水号
         * 长度：30
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 缴款单位人纳税人识别号
         * 长度：30
         */
        @JSONField(name = "jkdwrnsrsbh")
        private String taxNo;

        /**
         * 批次流水号
         * 长度：30
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 明细数据
         */
        @JSONField(name = "hgjksmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {

            /**
             * 填发日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 海关缴款书号码
             * 长度：75
             */
            @JSONField(name = "hgjkshm")
            private String customsPaymentNo;

            /**
             * 处理结果
             * 1是
             * 1入账（撤销）成功
             * 2查无此票
             * 3该票异常无法入账
             * 4重复入账
             * 5其他
             */
            @JSONField(name = "cljg")
            private String returnStatus;

            /**
             * 入账时间
             * 撤销入账时，此字段为空
             * YYYYMMDD
             * 长度：8
             * 非必填
             */
            @JSONField(name = "rzsj")
            private String entryDate;

            /**
             * 已入账属期
             * 长度：6
             * 非必填
             * 处理结果为4-重复入账时，根据实际情况反馈此码值。
             * 格式YYYYMM
             */
            @JSONField(name = "yrzskssq")
            private String period;
        }
    }
}
