package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 发票批量下载结果
 */
public class PostInvoiceDownloadResultMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         * 长度：32
         */
        @JSONField(name = "lsh")
        private String taskId;

        /**
         * 数据包号，当数据量过大时会进行分包处理，初始包号
         * 长度：5
         */
        @JSONField(name = "packageno")
        private String packageNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 当前流水号下 的总包数
         * 长度：5
         */
        @JSONField(name = "packagecount")
        private String packageCount;

        /**
         * 纳税人识别号/统一社会信用代码
         * 长度：30
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 发票类型
         * 长度：2
         * 01:增值税专用发票
         * 02:货物运输业增值税专用发票
         * 03:机动车销售统一发票
         * 04:增值税普通发票
         * 08:增值税电子专用发票
         * 10:增值税电子普通发票
         * 11:卷式发票
         * 14:通行费发票
         * 15:二手车销售统一发票
         * 81:电子发票(增值税专用发票)
         * 82:电子发票(普通发票)
         * 85:纸质发票(增值税专用发票)
         * 86:纸质发票(普通发票)
         * 51:电子发票(铁路电子客票)
         * 61:电子发票(航空运输客票电子行程单)
         * */
        @JSONField(name = "fplx")
        private String invoiceType;

        /**
         * 数据类型
         * 长度：1
         * 1:进项票
         * 2:销项票
         */
        @JSONField(name = "sjlx")
        private String dataType;

        /**
         * 处理结果
         * 长度：1
         *1:成功
         * 2:不存在符合条件的发票
         * 3:失败
         */
        @JSONField(name = "cljg")
        private String returnStatus;

        /**
         * 数据类型
         * 压缩包文件流 (gzip+base64)，
         * 原始数据为json报文Json
         */
        @JSONField(name = "sjl")
        private String returnData;
    }
}
