package com.xforceplus.taxware.leqi.kernel.contract.model.nscc.auth;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 获取二维码
 *
 * @author zhouwen
 * @date 2024-06-21 13:05
 */
public class PostQrCodeMessage {

    @Data
    public static class Request {

        /**
         * 授权人证件号码
         */
        private String idCard;

        /**
         * 授权人证件类型
         *   201 居民身份证
         *   208 外国护照
         *   210 港澳居民来往内地通行证
         *   213 台湾居民来往大陆通行证
         *   227 中国护照
         *   233 外国人永久居留证
         *   237 中华人民共和国港澳居民居住证
         *   238 中华人民共和国台湾居民居住证
         *   239 中华人民共和国外国人工作许可证（A类）
         *   240 中华人民共和国外国人工作许可证（B类）
         *   241 中华人民共和国外国人工作许可证（C类）
         *   299 其他个人证件
         */
        private String idCardType;

        /**
         * 自然人类型
         *   01 法定代表人
         *   02 财务负责人
         */
        private String relatedType;
    }

    @Data
    public static class ResultData {

        /**
         * 二维码id
         */
        @JSONField(name = "qrcode_id")
        private String qrcodeId;

        /**
         * 二维码内容
         */
        @JSONField(name = "qrcode")
        private String qrCode;
    }
}
