package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author zhenmengying
 * @date 2023/1/17
 * @describe: 下载/退回授信额度
 */
public class PostDownloadSendBackCreditLineMessage {

    /**
     * 下载
     */
    public static final String DOWNLOAD_TYPE = "0";

    /**
     * 退回
     */
    public static final String SEND_BACK_TYPE = "1";

    @Data
    public static class Request {

        /**
         * 申领发票的纳税人识别号或统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 平台编号（使用方平台编号）
         */
        @JSONField(name = "ptbh")
        private String platformNo;

        /**
         * 申请类型
         * 0：下载
         * 1：退回
         */
        @JSONField(name = "sqlx")
        private String applyType;

        /**
         * 申请额度
         */
        @JSONField(name = "sqed")
        private BigDecimal applyCreditLine;

        /**
         * 业务流水号（“使用单位 id”+“直连单位 id”+“32 位随机生成数” ）
         */
        @JSONField(name = "ywlsh")
        private String serialNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 授信额度使用区间起（非必须）
         * 下载授信额度时，有此节点
         * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
         */
        @JSONField(name = "syqjq")
        private String startCreditLineDate;

        /**
         * 授信额度使用区间止（非必须）
         * 下载授信额度时，有此节点
         * 全电发票开票日期在授信额度使用区间（含）时才可以使用.格式：yyyymmdd
         */
        @JSONField(name = "syqjz")
        private String endCreditLineDate;
    }

}
