package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/6/26
 * @describe: 查询发票汇总确认信息
 */
public class PostInvoiceSummaryMessage {

    @Data
    public static class Request {

        /**
         * 销售方纳税人识别号
         */
        @JSONField(name = "xsfnsrsbh")
        private String sellerTaxNo;

        /**
         * 销售方省级税务机关代码
         */
        @JSONField(name = "xsfsjswjgdm")
        private String sellerProvincialTaxAuthorityCode;

        /**
         * 平台编号
         * 若为空，则查询纳税人在所有平台的开票汇总信息
         * 非必填
         */
        @JSONField(name = "ptbh")
        private String platformNo;

        /**
         * 月份
         * 格式：yyyy-MM 若为空，则查询所有历史月份数据
         * 非必填
         */
        @JSONField(name = "yf")
        private String month;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        @JSONField(name = "fphzqrxxList")
        private List<InvoiceSummary> invoiceSummaryList;

        @Data
        public static class InvoiceSummary {
            /**
             * 平台编号
             * 非必填
             */
            @JSONField(name = "ptbh")
            private String platformNo;

            /**
             * 月份
             * 格式：yyyy-MM
             * 非必填
             */
            @JSONField(name = "yf")
            private String month;

            /**
             * 蓝字发票数量
             * 业务类型为“0”时必填
             * 非必填
             */
            @JSONField(name = "lzfpsl")
            private Integer blueCount;

            /**
             * 蓝字发票金额
             * 业务类型为“0”时必填
             * 非必填
             */
            @JSONField(name = "lzfpje")
            private BigDecimal blueAmountWithoutTax;

            /**
             * 蓝字发票税额
             * 业务类型为“0”时必填
             * 非必填
             */
            @JSONField(name = "lzfpse")
            private BigDecimal blueTaxAmount;

            /**
             * 红字发票数量
             * 业务类型为“0”时必填
             * 非必填
             */
            @JSONField(name = "hzfpsl")
            private Integer redCount;

            /**
             * 红字发票金额
             * 业务类型为“0”时必填
             * 非必填
             */
            @JSONField(name = "hzfpje")
            private BigDecimal redAmountWithoutTax;

            /**
             * 红字发票税额
             * 业务类型为“0”时必填
             * 非必填
             */
            @JSONField(name = "hzfpse")
            private BigDecimal redTaxAmount;
        }
    }
}
