package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author zhenmengying
 * @date 2023/6/26
 * @describe: 上传发票汇总确认信息
 */
public class PostInvoiceSummaryUploadMessage {

    /**
     * 确认
     */
    public static final String CONFIRM_TYPE = "0";

    /**
     * 取消
     */
    public static final String CANCEL_TYPE = "1";

    @Data
    public static class Request {

        /**
         * 销售方纳税人识别号
         */
        @JSONField(name = "xsfnsrsbh")
        private String sellerTaxNo;

        /**
         * 销售方省级税务机关代码
         */
        @JSONField(name = "xsfsjswjgdm")
        private String sellerProvincialTaxAuthorityCode;

        /**
         * 业务类型
         * 0：确认
         * 1：取消
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 平台编号
         */
        @JSONField(name = "ptbh")
        private String platformNo;

        /**
         * 月份
         * 格式：yyyy-MM
         */
        @JSONField(name = "yf")
        private String month;

        /**
         * 蓝字发票数量
         * 业务类型为“0”时必填
         * 非必填
         */
        @JSONField(name = "lzfpsl")
        private Integer blueCount;

        /**
         * 蓝字发票金额
         * 业务类型为“0”时必填
         * 非必填
         */
        @JSONField(name = "lzfpje")
        private BigDecimal blueAmountWithoutTax;

        /**
         * 蓝字发票税额
         * 业务类型为“0”时必填
         * 非必填
         */
        @JSONField(name = "lzfpse")
        private BigDecimal blueTaxAmount;

        /**
         * 红字发票数量
         * 业务类型为“0”时必填
         * 非必填
         */
        @JSONField(name = "hzfpsl")
        private Integer redCount;

        /**
         * 红字发票金额
         * 业务类型为“0”时必填
         * 非必填
         */
        @JSONField(name = "hzfpje")
        private BigDecimal redAmountWithoutTax;

        /**
         * 红字发票税额
         * 业务类型为“0”时必填
         * 非必填
         */
        @JSONField(name = "hzfpse")
        private BigDecimal redTaxAmount;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
    }
}
