package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import com.xforceplus.taxware.leqi.kernel.contract.model.seller.style.BuildingService;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lv
 * @date 2023/10/8
 * @describe: 全电发票上传-建筑服务
 */
public class PostInvoiceUploadBuildingServiceMessage {

    @Data
    public static class Request {

        private List<InvoiceInfo> invoiceInfoList;

        @Data
        public static class InvoiceInfo {

            /**
             * 发票号码
             * 由数字组成，前2位为年份后2位。
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 蓝字发票标志
             * 0：蓝字发票
             * 1：红字发票
             */
            @JSONField(name = "lzfpbz")
            private String invoiceFlag;

            /**
             * 平台编号
             */
            @JSONField(name = "ptbh")
            private String platformNo;

            /**
             * 发票票种
             * 01：全电专
             * 02：全电普
             */
            @JSONField(name = "fppz")
            private String invoiceType;

            /**
             * 购买方自然人标志（非必须）
             * Y：购买方是自然人
             * N：购买方非自然人
             */
            @JSONField(name = "gmfzrrbz")
            private String buyerTypeFlag;

            /**
             * 特定要素（非必须）
             * 空：非特定要素 空:""
             * 01：成品油发票
             * 02：稀土发票
             * 03：建筑服务发票
             * 04：货物运输服务发票
             * 05：不动产销售服务发票
             * 06：不动产租赁服务发票
             * 07：代收车船税
             * 08：通行费
             * 09：旅客运输服务发票
             * 10：医疗服务（住院）发票
             * 11：医疗服务（门诊）发票
             * 12：自产农产品销售发票
             * 13：拖拉机和联合收割机发票
             * 14：机动车
             * 15：二手车
             * 16：农产品收购发票
             * 17：光伏收购发票
             * 18：卷烟发票
             */
            @JSONField(name = "tdys")
            private String invoiceStyleType;

            /**
             * 区域代码
             */
            @JSONField(name = "qyDm")
            private String areaCode;

            /**
             * 差额征税类型代码（非必须）
             * 空：非差额发票
             * 01：差额开票
             * 02：全额开票
             */
            @JSONField(name = "cezslxDm")
            private String deductionType;

            /**
             * 收购发票类型代码（非必须）
             * 空：非收购发票
             * 01：农产品收购发票
             * 02：光伏收购发票
             * 03：二手车收购发票
             */
            @JSONField(name = "sgfplxDm")
            private String acquisitionTypeCode;

            /**
             * 出口业务适用政策代码（非必须）
             * 空：非出口业务
             * 01：退税政策
             * 02：免税政策
             * 03：征税政策
             */
            @JSONField(name = "ckywsyzcDm")
            private String exportPolicyCode;

            /**
             * 增值税即征即退代码（非必须）
             * 空：非增值税即征即退
             * 01：软件产品发票
             * 02：资源综合利用产品发票
             * 03：管道运输服务发票
             * 04：有形动产融资租赁服务
             * 05：有形动产融资性售后回租服务发票
             * 06：新型墙体材料发票
             * 07：风力发电产品发票
             * 08：光伏发电产品发票
             * 09：动漫软件产品发票
             * 10：飞机维修劳务发票
             * 11：黄金发票
             * 12：铂金发票
             */
            @JSONField(name = "zzsjzjtDm")
            private String vatRefundType;

            /**
             * 销售方统一社会信用代码/纳税人识别号/身份证件号码
             */
            @JSONField(name = "xsfnsrsbh")
            private String sellerTaxNo;

            /**
             * 销售方名称
             */
            @JSONField(name = "xsfmc")
            private String sellerName;

            /**
             * 销售方地址（非必须）
             */
            @JSONField(name = "xsfdz")
            private String sellerAddress;

            /**
             * 销售方电话（非必须）
             */
            @JSONField(name = "xsfdh")
            private String sellerTel;

            /**
             * 销售方开户行（非必须）
             */
            @JSONField(name = "xsfkhh")
            private String sellerBankName;

            /**
             * 销售方账号（非必须）
             */
            @JSONField(name = "xsfzh")
            private String sellerBankAccount;

            /**
             * 购买方统一社会信用代码/纳税人识别号/身份证件号码（非必须）
             */
            @JSONField(name = "gmfnsrsbh")
            private String buyerTaxNo;

            /**
             * 购买方名称
             */
            @JSONField(name = "gmfmc")
            private String buyerName;

            /**
             * 购买方地址（非必须）
             */
            @JSONField(name = "gmfdz")
            private String buyerAddress;

            /**
             * 购买方电话（非必须）
             */
            @JSONField(name = "gmfdh")
            private String buyerTel;

            /**
             * 购买方开户行（非必须）
             */
            @JSONField(name = "gmfkhh")
            private String buyerBankName;

            /**
             * 购买方账号（非必须）
             */
            @JSONField(name = "gmfzh")
            private String buyerBankAccount;

            /**
             * 购买方经办人姓名（非必须）
             */
            @JSONField(name = "gmfjbr")
            private String buyerOperatorName;

            /**
             * 购买方经办人证件号码（非必须）
             */
            @JSONField(name = "jbrsfzjhm")
            private String buyerOperatorIdentityNo;

            /**
             * 购买方经办人联系电话（非必须）
             * jbrlxdh修改为gmfjbrlxdh
             */
            @JSONField(name = "gmfjbrlxdh")
            private String buyerOperatorTel;

            /**
             * 合计金额
             */
            @JSONField(name = "hjje")
            private BigDecimal amountWithoutTax;

            /**
             * 合计税额
             */
            @JSONField(name = "hjse")
            private BigDecimal taxAmount;

            /**
             * 价税合计
             */
            @JSONField(name = "jshj")
            private BigDecimal amountWithTax;

            /**
             * 收款银行名称（非必须）
             */
            @JSONField(name = "skyhmc")
            private String payeeBankName;

            /**
             * 收款银行账号（非必须）
             */
            @JSONField(name = "skyhzh")
            private String payeeBankAccount;

            /**
             * 结算方式（非必须）
             * 01：现金
             * 02：银行转账
             * 03：票据
             * 04：第三方支付
             * 05：预付卡
             * 99：其他
             */
            @JSONField(name = "jsfs")
            private String settlementMode;

            /**
             * 应税行为发生地（非必须）
             */
            @JSONField(name = "ysxwfsd")
            private String taxablePlace;

            /**
             * 开票人
             */
            @JSONField(name = "kpr")
            private String issuer;

            /**
             * 开票人证件号码（非必须）
             */
            @JSONField(name = "kprzjhm")
            private String issuerIdentityNo;

            /**
             * 开票人证件类型（非必须）
             */
            @JSONField(name = "kprzjlx")
            private String issuerIdentityType;

            /**
             * 对应蓝字发票号码（非必须）
             */
            @JSONField(name = "dylzfphm")
            private String originalInvoiceNo;

            /**
             * 红字确认信息单编号（非必须）
             * 是否蓝字发票标志为1时，此节点有内容
             * 红票开具时必传
             */
            @JSONField(name = "hzqrxxdbh")
            private String redLetterNumber;

            /**
             * 红字确认单uuid（非必须）
             * 是否蓝字发票标志为1时，此节点有内容红票开具时必传
             */
            @JSONField(name = "hzqrduuid")
            private String redLetterUuid;

            /**
             * 备注（非必须）
             */
            @JSONField(name = "bz")
            private String remark;

            /**
             * 服务器地址
             */
            @JSONField(name = "ip")
            private String serverIp;

            /**
             * mac地址
             */
            @JSONField(name = "macdz")
            private String macAddress;

            /**
             * CPU序列号（非必须）
             */
            @JSONField(name = "cpuid")
            private String cpuSerialNo;

            /**
             * 主板序列号（非必须）
             */
            @JSONField(name = "zbxlh")
            private String motherboardSerialNo;

            /**
             * 开票日期
             * 格式：
             * yyyy-MM-dd HH:mm:ss
             */
            // @NotNull 赋码之前为空
            @JSONField(name = "kprq")
            private String dateTimeIssued;

            /**
             * 是否展示销方银行
             */
            @JSONField(name = "sfzsxsfyhzhbq")
            private String isShowSellerBankControl;

            /**
             * 是否展示购方银行
             */
            @JSONField(name = "sfzsgmfyhzhbq")
            private String isShowBuyerBankControl;

            /**
             * 收款人
             */
            @JSONField(name = "skrxm")
            private String payee;

            /**
             * 复核人
             */
            @JSONField(name = "fhrxm")
            private String reviewer;

            @JSONField(name = "jzfwtdys")
            private BuildingService buildingService;

            @JSONField(name = "fpmxList")
            private List<InvoiceDetail> invoiceDetailList;

            @JSONField(name = "fjysList")
            private List<Additional> additionalList;

            @Data
            public static class InvoiceDetail {
                /**
                 * 明细序号
                 */
                @JSONField(name = "mxxh")
                private Integer rowNum;

                /**
                 * 对应蓝字发票明细序号（非必须）
                 * 红票必传
                 */
                @JSONField(name = "dylzfpmxxh")
                private Integer originalRowNum;

                /**
                 * 项目名称
                 */
                @JSONField(name = "xmmc")
                private String itemSimpleName;

                /**
                 * 建筑服务发生地
                 * varchar
                 * 120
                 * 是
                 * 建筑服务发生 地县(市、区) 名称
                 */
                @JSONField(name = "jzfwfsd")
                private String place;

                /**
                 * 建筑项目名称
                 * varchar
                 * 80
                 * 否
                 * “不动产单位 代码”和“网签 合同备案编 号”两者只能 填一个
                 */
                @JSONField(name = "jzxmmc")
                private String entryName;

                /**
                 * 货物或应税劳务、服务名称
                 * 拼装规则：“*商品服务简称（spfwjc）*”+“项目名称（xmmc）”
                 */
                @JSONField(name = "hwhyslwfwmc")
                private String itemName;

                /**
                 * 商品服务简称
                 */
                @JSONField(name = "spfwjc")
                private String itemShortName;

                /**
                 * 规格型号（非必须）
                 */
                @JSONField(name = "ggxh")
                private String specifications;

                /**
                 * 单位（非必须）
                 * 如“数量”“单价”栏次非空，则本栏次必须非空
                 */
                @JSONField(name = "dw")
                private String unit;

                /**
                 * 数量（非必须）
                 * 如“单价”“单位”栏次非空，则本栏次必须非空
                 */
                @JSONField(name = "sl")
                private String quantity;

                /**
                 * 单价（非必须）
                 * 如“数量”“单位”栏次非空，则本栏次必须非空
                 */
                @JSONField(name = "dj")
                private String unitPrice;

                /**
                 * 金额
                 * 最大长度18位，最多2位小数。
                 */
                @JSONField(name = "je")
                private BigDecimal amountWithoutTax;

                /**
                 * 增值税税率/征收率
                 */
                @JSONField(name = "slv")
                private BigDecimal taxRate;

                /**
                 * 税额
                 */
                @JSONField(name = "se")
                private BigDecimal taxAmount;

                /**
                 * 含税金额
                 */
                @JSONField(name = "hsje")
                private BigDecimal amountWithTax;

                /**
                 * 扣除额（非必须）
                 */
                @JSONField(name = "kce")
                private BigDecimal deduction;

                /**
                 * 商品和服务税收分类合并编码
                 * 必须在商品编码信息中存在。
                 */
                @JSONField(name = "sphfwssflhbbm")
                private String goodsTaxNo;

                /**
                 * 发票行性质
                 * 00：正常行
                 * 01：折扣行
                 * 02：被折扣行
                 */
                @JSONField(name = "fphxz")
                private String discountType;

                /**
                 * 优惠政策标识（非必须）
                 * 01：简易征收
                 * 02：稀土产品
                 * 03：免税
                 * 04：不征税
                 * 05：先征后退
                 * 06：100%先征后退
                 * 07：50%先征后退
                 * 08：按3%简易征收
                 * 09：按5%简易征收
                 * 10：按5%简易征收减按1.5%计征
                 * 11：即征即退30%
                 * 12：即征即退50%
                 * 13：即征即退70%
                 * 14：即征即退100%
                 * 15：超税负3%即征即退
                 * 16：超税负8%即征即退
                 * 17：超税负12%即征即退
                 * 18：超税负6%即征即退
                 */
                @JSONField(name = "yhzcbs")
                private String taxIncentivesType;

                /**
                 * 产权证书/不动产权证号
                 * varchar
                 * 40
                 * 否
                 */
                @JSONField(name = "cqzsbh")
                private String realEstateNo;
            }

            @Data
            public static class Additional {

                /**
                 * 附加要素名称（非必须）
                 */
                @JSONField(name = "fjysmc")
                private String additionalElementName;

                /**
                 * 附加要素类型（非必须）
                 */
                @JSONField(name = "fjyslx")
                private String additionalElementType;

                /**
                 * 附加要素值（非必须）
                 */
                @JSONField(name = "fjysz")
                private String additionalElementValue;
            }
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 受理流水号
         */
        @JSONField(name = "sllsh")
        private String taskId;
    }
}
