package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 全电红字确认单申请
 */
public class PostRedLetterApplyMessage {

    @Data
    public static class Request {

        /**
         * 录入方身份
         * 0：销方
         * 1：购方
         */
        @JSONField(name = "lrfsf")
        private String applyIdentity;

        /**
         * 销售方纳税人识别号
         * 由数字和大写字母组成。
         */
        @JSONField(name = "xsfnsrsbh")
        private String sellerTaxNo;

        /**
         * 销售方名称
         */
        @JSONField(name = "xsfmc")
        private String sellerName;

        /**
         * 购买方纳税人识别号（非必须）
         */
        @JSONField(name = "gmfnsrsbh")
        private String buyerTaxNo;

        /**
         * 购买方名称
         */
        @JSONField(name = "gmfmc")
        private String buyerName;

        /**
         * 蓝字发票代码（非必须）
         */
        @JSONField(name = "lzfpdm")
        private String originalInvoiceCode;

        /**
         * 蓝字发票号码
         */
        @JSONField(name = "lzfphm")
        private String originalInvoiceNo;

        /**
         * 是否纸质发票标志
         * Y：纸质发票
         * N：电子发票
         */
        @JSONField(name = "sfzzfpbz")
        private String paperInvoiceFlag;

        /**
         * 蓝字发票开票日期
         * yyyy-MM-dd HH:mm:ss
         */
        @JSONField(name = "lzkprq", format = "yyyy-MM-dd HH:mm:ss")
        private String originalDateTimeIssued;

        /**
         * 蓝字发票合计金额
         */
        @JSONField(name = "lzhjje")
        private BigDecimal originalAmountWithoutTax;

        /**
         * 蓝字发票合计税额
         */
        @JSONField(name = "lzhjse")
        private BigDecimal originalTaxAmount;

        /**
         * 蓝字发票票种代码
         * 01: 增值税专用发票
         * 02: 普通发票
         * 03: 机动车统一销售发票
         * 04: 二手车统一销售发票
         */
        @JSONField(name = "lzfppzDm")
        private String originalInvoiceType;

        /**
         * 蓝字发票特定要素类型代码（非必须）
         * 01：成品油发票
         * 02：稀土发票
         * 03：建筑服务发票
         * 04：货物运输服务发票
         * 05：不动产销售服务发票
         * 06：不动产租赁服务发票
         * 07：代收车船税
         * 08：通行费
         * 09：旅客运输服务发票
         * 10：医疗服务（住院）发票
         * 11：医疗服务（门诊）发票
         * 12：自产农产品销售发票
         * 13 拖拉机和联合收割机发票
         * 14：机动车
         * 15：二手车
         * 16：农产品收购发票
         * 17：光伏收购发票
         * 18：卷烟发票
         */
        @JSONField(name = "lzfpTdyslxDm")
        private String originalInvoiceStyleType;

        /**
         * 红字冲销金额
         */
        @JSONField(name = "hzcxje")
        private BigDecimal reverseAmountWithoutTax;

        /**
         * 红字冲销税额
         */
        @JSONField(name = "hzcxse")
        private BigDecimal reverseTaxAmount;

        /**
         * 红字发票冲红原因代码
         * 01：开票有误
         * 02：销货退回
         * 03：服务中止
         * 04：销售折让
         */
        @JSONField(name = "chyyDm")
        private String applyReason;

        @JSONField(name = "hzqrdmxList")
        private List<Detail> details;

        @Data
        public static class Detail {

            /**
             * 蓝字发票明细序号（非必须）
             */
            @JSONField(name = "lzmxxh")
            private Integer originalRowNum;

            /**
             * 序号
             * 8位，从1开始。
             */
            @JSONField(name = "xh")
            private Integer rowNum;

            /**
             * 商品和服务税收分类合并编码
             */
            @JSONField(name = "sphfwssflhbbm")
            private String goodsTaxNo;

            /**
             * 货物或应税劳务、服务名称
             * 格式必须是“*简称*商品名称
             */
            @JSONField(name = "hwhyslwfwmc")
            private String itemName;

            /**
             * 商品服务简称
             */
            @JSONField(name = "spfwjc")
            private String itemShortName;

            /**
             * 项目名称
             */
            @JSONField(name = "xmmc")
            private String itemSimpleName;

            /**
             * 规格型号（非必须）
             */
            @JSONField(name = "ggxh")
            private String specifications;

            /**
             * 单位（非必须）
             * 如“数量”“单价”栏次非空，则本栏次必须非空
             * 成品油: 只能是“吨”“升”两个选项，不允许修改和自定义
             */
            @JSONField(name = "dw")
            private String unit;

            /**
             * 单价（非必须）
             * 如“数量”“单位”栏次非空，则本栏次必须非空
             * 文档上还有一个说法，选填（如“单位”非空，则必填）
             */
            @JSONField(name = "fpspdj")
            private String unitPrice;

            /**
             * 数量（非必须）
             * 如“单价”“单价”栏次非空，则本栏次必须非空
             * 文档上还有一个说法，选填（如“单位”非空，则必填）
             */
            @JSONField(name = "fpspsl")
            private String quantity;

            /**
             * 金额
             */
            @JSONField(name = "je")
            private BigDecimal amountWithoutTax;

            /**
             * 税率
             * 必须在可用税率信息中存在。
             */
            @JSONField(name = "sl1")
            private BigDecimal taxRate;

            /**
             * 税额
             */
            @JSONField(name = "se")
            private BigDecimal taxAmount;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 红字确认单编号（非必须）
         */
        @JSONField(name = "hzfpxxqrdbh")
        private String redLetterNumber;

        /**
         * 红字确认单UUID（非必须）
         */
        @JSONField(name = "uuid")
        private String redLetterUuid;

        /**
         * 红字确认单状态（非必须）
         * 01：无需确认
         * 02：销方录入待购方确认
         * 03：购方录入待销方确认
         * 04：购销双方已确认
         * 05：作废（销方录入购方否认）
         * 06：作废（购方录入销方否认）
         * 07：作废（超72小时未确认）
         * 08：（发起方撤销）
         * 09：作废（确认后撤销）
         * 10作废（异常凭证）
         */
        @JSONField(name = "hzqrxxztDm")
        private String redLetterStatus;
    }
}
