package com.xforceplus.taxware.leqi.kernel.contract.model.seller.style;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Auther lv
 * @Date 2023/10/11
 * @Description 不动产销售特殊要素信息
 */
@Data
public class RealEstateSales {

    /**
     * 序号
     * 需要和发票明细一一对应
     */
    @JSONField(name = "xh")
    private Integer rowNum;

    /**
     * 不动产单位代码
     * varchar
     * 28
     * 否
     * “不动产单位 代码”和“网签 合同备案编 号”两者只能 填一个
     */
    @JSONField(name = "bdcdwdm")
    private String realEstateCode;

    /**
     * 网签合同备案编号
     * varchar
     * 28
     * 否
     * “不动产单位 代码”和“网签 合同备案编 号”两者只能 填一个
     */
    @JSONField(name = "wqhtbabh")
    private String contractNo;

    /**
     * 不动产坐落地址(省)
     */
    @JSONField(name = "bdczldzS")
    private String landVatItemProvince;

    /**
     * 不动产坐落地址(市)
     */
    @JSONField(name = "bdczldzS1")
    private String landVatItemCity;

    /**
     * 不动产坐落详细地址
     */
    @JSONField(name = "bdczldzXxdz")
    private String landVatItemAddress;

    /**
     * 土地增值税项目编号
     * varchar
     * 16
     * 否
     */
    @JSONField(name = "tdzzsxmbh")
    private String landVatItemNo;

    /**
     * 跨地(市)标志
     * varchar
     * 1
     * 是
     * Y是N否
     */
    @JSONField(name = "kdsbz")
    private String crossCitySign;

    /**
     * 核定计税价格
     * number
     * 18,2
     * 否
     * 不属于核定计税不动产销售的可不填写
     */
    @JSONField(name = "hdjsjg")
    private BigDecimal taxablePrice;

    /**
     * 实际成交含税金额
     * number
     * 18,2
     * 否
     * 若按核定计税价格征税的，为必填。
     */
    @JSONField(name = "sjcjhsje")
    private BigDecimal transactionPrice;

    /**
     * 产权证书/不动产权证号
     * varchar
     * 40
     * 否
     */
    @JSONField(name = "cqzsbh")
    private String realEstateNo;
}
