package com.xforceplus.taxware.leqi.kernel.contract.model.base.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Auther lv
 * @Date 2023/7/18
 * @Description 二手车销售统一发票数据
 *
 *      15：二手车销售统一发票
 */
@Data
public class InvoiceUsedCar {
    /**
     * 发票代码
     * 长度：12
     * 必需
     */
    @JSONField(name = "fpdm")
    private String invoiceCode;

    /**
     * 纸质发票号码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "zzfphm")
    private String invoiceNo;

    /**
     * 发票号码
     * 长度：20
     * 必需
     */
    @JSONField(name = "fphm")
    private String allElectricInvoiceNo;

    /**
     * 报税纳税人识别号
     * 长度：20
     * 必填
     */
    @JSONField(name = "bsNsrsbh")
    private String taxNo;

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     * 长度：19
     * 必需
     */
    @JSONField(name = "kprq")
    private String dateTimeIssued;

    /**
     * 税控码
     * 长度：200
     * 非必需
     */
    @JSONField(name = "skm")
    private String cipherText;

    /**
     * 买方单位/个人名称（购方名称）
     * 长度：300
     * 必需
     */
    @JSONField(name = "gfMc")
    private String buyerName;

    /**
     * 买方单位/个人代码（购方识别号）
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gfDm")
    private String buyerTaxNo;

    /**
     * 买方单位/个人地址
     * 长度：310
     * 非必需
     */
    @JSONField(name = "gfDz")
    private String buyerAddress;

    /**
     * 买方单位/个人电话
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gfDh")
    private String buyerTel;

    /**
     * 开票方纳税人识别号（销方识别号）
     * 长度：20
     * 非必需
     */
    @JSONField(name = "kpfNsrsbh")
    private String issuedTaxNo;

    /**
     * 卖方单位/个人名称
     * 长度：300
     * 必需
     */
    @JSONField(name = "xfMc")
    private String sellerName;

    /**
     * 卖方单位/个人代码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "xfDm")
    private String sellerTaxNo;

    /**
     * 卖方单位/个人地址
     * 长度：310
     * 非必需
     */
    @JSONField(name = "xfDz")
    private String sellerAddress;

    /**
     * 卖方单位/个人电话
     * 长度：20
     * 非必需
     */
    @JSONField(name = "xfDh")
    private String sellerTel;

    /**
     * 车牌照号
     * 长度：32
     * 非必需
     */
    @JSONField(name = "cphm")
    private String vehicleLicensePlateNo;

    /**
     * 登记证号
     * 长度：32
     * 非必需
     */
    @JSONField(name = "djzh")
    private String registrationNo;

    /**
     * 车辆类型
     * 长度：128
     * 非必需
     */
    @JSONField(name = "cllx")
    private String vehicleType;

    /**
     * 车架号/车辆识别号
     * 长度：64
     * 非必需
     */
    @JSONField(name = "clsbh")
    private String vehicleNo;

    /**
     * 厂牌型号
     * 长度：210
     * 非必需
     */
    @JSONField(name = "cpxh")
    private String vehicleBrand;

    /**
     * 转入地车辆管理所名称
     * 长度：310
     * 非必需
     */
    @JSONField(name = "zrdclglsMc")
    private String transferVehicleManagementName;

    /**
     * 经营、拍卖单位名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "jyPmMc")
    private String operationAuctionUnitName;

    /**
     * 经营、拍卖单位地址
     * 长度：310
     * 非必需
     */
    @JSONField(name = "jyPmDz")
    private String operationAuctionUnitAddress;

    /**
     * 经营、拍卖单位纳税人识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "jyPmSbh")
    private String operationAuctionUnitTaxNo;

    /**
     * 经营、拍卖单位开户行、账号
     * 长度：250
     * 非必需
     */
    @JSONField(name = "jyPmYhZh")
    private String operationAuctionUnitBankInfo;

    /**
     * 经营、拍卖单位电话
     * 长度：80
     * 非必需
     */
    @JSONField(name = "jyPmDh")
    private String operationAuctionUnitTel;

    /**
     * 二手车市场名称
     * 长度：300
     * 非必需
     */
    @JSONField(name = "escMc")
    private String usedCarMarketName;

    /**
     * 二手车市场识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "escSbh")
    private String usedCarMarketTaxNo;

    /**
     * 二手车市场地址
     * 长度：310
     * 非必需
     */
    @JSONField(name = "escDz")
    private String usedCarMarketAddress;

    /**
     * 二手车市场开户行、账号
     * 长度：250
     * 非必需
     */
    @JSONField(name = "escYhZh")
    private String usedCarMarketBankInfo;

    /**
     * 二手车市场电话
     * 长度：80
     * 非必需
     */
    @JSONField(name = "escDh")
    private String usedCarMarketTel;

    /**
     * 车价合计：单位：元
     * 非必需
     */
    @JSONField(name = "cjhj")
    private BigDecimal amountWithoutTax;

    /**
     * 开票人
     * 长度：150
     * 非必需
     */
    @JSONField(name = "kpr")
    private String issuer;

    /**
     * 备注
     * 长度：610
     * 非必需
     */
    @JSONField(name = "bz")
    private String remark;

    /**
     * 开票类型
     * 长度：1
     * 非必需
     */
    @JSONField(name = "kjlx")
    private String issuedType;

    /**
     * 商品编码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "spbm")
    private String goodsTaxNo;

    /**
     * 纳税人自行编码
     * 长度：40
     * 非必需
     */
    @JSONField(name = "zxbm")
    private String itemCode;

    /**
     * 优惠政策标识
     * 长度：1
     * 非必需
     */
    @JSONField(name = "yhzcbs")
    private String taxPreFlag;

    /**
     * 零税率标识
     * 长度：10
     * 非必需
     * 空：代表无
     * 0：出口退税
     * 1：出口免税和其他免税政策
     * 2：不征税措施
     * 3：普通零税率
     */
    @JSONField(name = "lslbs")
    private String zeroTax;

    /**
     * 增值税特殊管理
     * 长度：760
     * 非必需
     */
    @JSONField(name = "zzstsgl")
    private String specialManagement;

    /**
     * 适用税率标识
     * 长度：1
     * 非必需
     */
    @JSONField(name = "syslbs")
    private String applyTaxRateFlag;
}
