package com.xforceplus.taxware.leqi.kernel.contract.model.base.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/18
 * @Description 全电增值税发票数据
 *
 *      81：电子发票（增值税专用发票）
 *      82：电子发票（普通发票）
 *      85：纸质发票（增值税专用发票）
 *      86：纸质发票（普通发票）
 */
@Data
public class InvoiceVatAllElectronic {

    /**
     * 发票号码
     * 长度：20
     * 必需
     */
    @JSONField(name = "fphm")
    private String allElectricInvoiceNo;

    /**
     * 纸质发票代码
     * 长度：12
     * 非必需
     */
    @JSONField(name = "zzfpDm")
    private String invoiceCode;

    /**
     * 纸质发票号码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "zzfphm")
    private String invoiceNo;

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     * 长度：19
     * 必需
     */
    @JSONField(name = "kprq")
    private String dateTimeIssued;

    /**
     * 发票票种代码
     * 长度：2
     * 必需
     */
    @JSONField(name = "fppzDm")
    private String invoiceType;

    /**
     * 特定要素类型代码
     * 长度：2
     * 非必需
     */
    @JSONField(name = "tdyslxDm")
    private String invoiceStyleType;

    /**
     * 是否蓝字发票
     * 长度：1
     * 必需
     * Y：是 N：否
     */
    @JSONField(name = "sflzfp")
    private String invoiceFlag;

    /**
     * 开具红字发票对应的蓝字发票号码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "kjhzfpdydlzfphm")
    private String originalAllElectricInvoiceNo;

    /**
     * 开具红字发票对应的纸质发票代码
     * 长度：12
     * 非必需
     */
    @JSONField(name = "kjhzfpdydzzfpDm")
    private String originalInvoiceCode;

    /**
     * 开具红字发票对应的纸质发票号码
     * 长度：20
     * 非必需
     */
    @JSONField(name = "kjhzfpdydzzfphm")
    private String originalInvoiceNo;

    /**
     * 销售方识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "xsfnsrsbh")
    private String sellerTaxNo;

    /**
     * 销售方名称
     * 长度：150
     * 必需
     */
    @JSONField(name = "xsfmc")
    private String sellerName;

    /**
     * 销货方地址
     * 长度：250
     * 非必需
     */
    @JSONField(name = "xhfdz")
    private String sellerAddress;

    /**
     * 购买方识别号
     * 长度：20
     * 非必需
     */
    @JSONField(name = "gmfnsrsbh")
    private String buyerTaxNo;

    /**
     * 购买方名称
     * 长度：150
     * 必需
     */
    @JSONField(name = "gmfmc")
    private String buyerName;

    /**
     * 购买方地址
     * 长度：300
     * 非必需
     */
    @JSONField(name = "gmfdz")
    private String buyerAddress;

    /**
     * 合计金额
     * 必需
     */
    @JSONField(name = "hjje")
    private BigDecimal amountWithoutTax;

    /**
     * 合计税额
     * 必需
     */
    @JSONField(name = "hjse")
    private BigDecimal taxAmount;

    /**
     * 价税合计
     * 必需
     */
    @JSONField(name = "jshj")
    private BigDecimal amountWithTax;

    /**
     * 价税合计（大写）
     * 长度：300
     * 必需
     */
    @JSONField(name = "jshjdx")
    private String amountWithTaxCapital;

    /**
     * 扣除额
     * 非必需
     */
    @JSONField(name = "kce")
    private BigDecimal deduction;

    /**
     * 结算方式
     * 非必需
     */
    @JSONField(name = "jsfsDm")
    private String settlementMode;

    /**
     * 开票人
     * 非必需
     */
    @JSONField(name = "kpr")
    private String issuer;

    /**
     * 备注
     * 长度：450
     * 非必需
     */
    @JSONField(name = "bz")
    private String remark;

    /**
     * 明细条数
     * 长度：20
     * 非必需
     */
    @JSONField(name = "xmmxhs")
    private Integer detailCount;

    /**
     * 增值税即征即退代码
     * 长度：2
     * 必需
     */
    @JSONField(name = "zzsjzjtDm")
    private String vatRefundType;

    /**
     * 出口退税类代码
     * 长度：2
     * 非必需
     */
    @JSONField(name = "cktslDm")
    private String exportPolicyCode;

    /**
     * 复核人姓名
     * 长度：75
     * 非必需
     */
    @JSONField(name = "fhrxm")
    private String reviewer;

    /**
     * 收款人名称
     * 长度：150
     * 非必需
     */
    @JSONField(name = "skrxm")
    private String payee;

    /**
     * 销售方电话
     * 长度：60
     * 非必需
     */
    @JSONField(name = "xsfdh")
    private String sellerTel;

    /**
     * 销售方开户行
     * 长度：120
     * 非必需
     */
    @JSONField(name = "xsfkhh")
    private String sellerBankName;

    /**
     * 销售方账号
     * 长度：100
     * 非必需
     */
    @JSONField(name = "xsfzh")
    private String sellerBankAccount;

    /**
     * 购买方电话
     * 长度：60
     * 非必需
     */
    @JSONField(name = "gmfdh")
    private String buyerTel;

    /**
     * 购买方开户行
     * 长度：120
     * 非必需
     */
    @JSONField(name = "gmfkhh")
    private String buyerBankName;

    /**
     * 购买方账号
     * 长度：100
     * 非必需
     */
    @JSONField(name = "gmfzh")
    private String buyerBankAccount;

    @JSONField(name = "hwxx")
    private List<Detail> detailList;

    @Data
    public static class Detail {

        /**
         * 序号
         * 长度：11
         * 必需
         */
        @JSONField(name = "xh")
        private Integer rowNum;

        /**
         * 项目名称
         * 长度：600
         * 必需
         */
        @JSONField(name = "xmmc")
        private String itemSimpleName;

        /**
         * 商品服务简称
         * 长度：120
         * 必需
         */
        @JSONField(name = "spfwjc")
        private String itemShortName;

        /**
         * 货物或应税劳务、服务名称
         * 长度：300
         * 必需
         */
        @JSONField(name = "hwhyslwfwmc")
        private String itemName;

        /**
         * 商品和服务税收分类合并编码
         * 长度：19
         * 非必需
         */
        @JSONField(name = "sphfwssflhbbm")
        private String goodsTaxNo;

        /**
         * 规格型号
         * 长度：150
         * 非必需
         */
        @JSONField(name = "ggxh")
        private String specifications;

        /**
         * 单位
         * 长度：300
         * 非必需
         */
        @JSONField(name = "dw")
        private String unit;

        /**
         * 发票交易数量
         * 长度：25
         * 非必需
         */
        @JSONField(name = "fpjysl")
        private String quantity;

        /**
         * 发票交易单价
         * 长度：25
         * 必需
         */
        @JSONField(name = "fpjydj")
        private String unitPrice;

        /**
         * 税率
         * 必需
         */
        @JSONField(name = "slv")
        private BigDecimal taxRate;

        /**
         * 税额
         * 必需
         */
        @JSONField(name = "se")
        private BigDecimal taxAmount;

        /**
         * 金额
         * 必需
         */
        @JSONField(name = "je")
        private BigDecimal amountWithoutTax;

        /**
         * 扣除额
         * 非必需
         */
        @JSONField(name = "kce")
        private BigDecimal deduction;
    }
}
