package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 批量上传海关缴款书抵扣勾选
 */
public class PostCustomsPaymentDeductionUpload {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：20
         * 非必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 勾选类型
         * 长度：2
         * 必需
         * 01.申请抵扣
         * 02.撤销抵扣
         * 03.申请不抵扣
         * 04.撤销不抵扣
         */
        @JSONField(name = "gxlxDm")
        private String deductionType;

        @JSONField(name = "hgjksmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 缴款书号码
             * 长度：22
             * 必填
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 填发日期
             * 长度：8
             * 必填
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 不抵扣类型
             * 长度：2
             * 非必填
             * 申请勾选类型选择03：申请不抵扣时，需选择以下不抵扣类型
             * 1:用于非应税项目
             * 2:用于免税项目
             * 3:用于集体福利或者个人消费
             * 4:遭受非正常损失
             * 5:其他
             */
            @JSONField(name = "bdklx")
            private String unDeductionType;

            /**
             * 不抵扣原因
             * 长度：300
             * 非必填
             * 不抵扣类型选择为5:其他时，需要录入不抵扣原因
             */
            @JSONField(name = "bdkyy")
            private String unDeductionReason;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;

        @JSONField(name = "hgjksmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 缴款书号码
             * 长度：22
             * 必填
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 上传状态
             * 长度：2
             * 必需
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sczt")
            private String uploadStatus;

            /**
             * 错误码
             * 长度：2000
             * 非必须
             * 01：失败时记录失败原因
             */
            @JSONField(name = "errormsg")
            private String errorMsg;

        }
    }
}
