package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 查询批量上传待处理农产品发票确认清单处理结果
 */
public class PostInvoiceAgriculturalProductsToBeProcessedUploadResult {
    @Data
    public static class Request {
        /**
         * 批次流水号
         * 长度：32
         * 非必填
         * 返回码不是 00：成功时，不返回
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 非必填
         * 返回码不是 00：成功时，不返回
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "fpmx")
        private List<Detail> details;

        @Data
        public static class Detail {
            /**
             * 购买方统一社会信用代码/纳税人识别号
             * 长度：30
             * 必填
             */
            @JSONField(name = "gfsbh")
            private String taxNo;

            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 发票类型
             * 长度：2
             * 必填
             * 农产品类型为
             * 01：增值税专用发票
             * 04：增值税普通发票
             * 08：增值税电子专用发票
             * 10：增值税电子普通发票
             * 81：电子发票（增值税专用发票）
             * 85：纸质发票（增值税专用发票）
             * */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 农产品类型
             * 长度：2
             * 必填
             * 1：自产农产品销售发票
             * 2：从小规模处购进的
             * 3：农产品专票
             */
            @JSONField(name = "ncplx")
            private String agriculturalProductsType;

            /**
             * 处理结果
             * 长度：2
             * 必填
             * 20：待处理农产品发票确认成功
             * 21：非待处理农产品发票
             * 22：已勾选无 法进行待处理农产品确认
             * 23：未录入农产品部分金额（选择部分属于自产时）
             * 99：其他
             */
            @JSONField(name = "cljg")
            private String returnStatus;

            /**
             * 确认时间
             * 长度：19
             * 非必填
             * YYYY-MM-DD HH:mm:ss
             */
            @JSONField(name = "qrsj")
            private String confirmTime;

            /**
             * 有效抵扣税额
             * 非必填
             */
            @JSONField(name = "yxdkse")
            private BigDecimal effectiveTaxAmount;

            /**
             * 农产品部分金额
             * 非必填
             */
            @JSONField(name = "ncpbfje")
            private BigDecimal agriculturalProductsAmountWithoutTax;

            /**
             * 农产品部分税额
             * 非必填
             */
            @JSONField(name = "ncpbfse")
            private BigDecimal agriculturalProductsTaxAmount;
        }
    }
}
