package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.entry;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/11/15
 * @Description 查询发票入账处理结果
 */
public class PostInvoiceEntryUploadResult {
    @Data
    public static class Request {

        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 发票类型
             * 长度：2
             * 必填
             */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 处理结果
             * 1是
             * 1入账（撤销）成功
             * 2查无此票
             * 3该票异常无法入账
             * 4重复入账
             * 5其他
             */
            @JSONField(name = "cljg")
            private String returnStatus;

            /**
             * 入账时间
             * 撤销入账时，此字段为空
             * YYYYMMDD
             * 长度：8
             * 非必填
             */
            @JSONField(name = "rzsj")
            private String entryDate;

            /**
             * 发票状态
             * 长度：2
             * 非必填
             * 处理结果为3-该票异常无法勾选时，根据实际情况反馈此码值。
             * 0正常
             * 2作废
             * 3已红冲
             * 7已部分冲红
             * 8已全额红冲
             */
            @JSONField(name = "fpzt")
            private String status;

            /**
             * 已入账属期
             * 长度：6
             * 非必填
             * 处理结果为4-重复入账时，根据实际情况反馈此码值。
             * 格式YYYYMM
             */
            @JSONField(name = "yrzskssq")
            private String period;

            /**
             * 成品油异常标识
             * 长度：1
             * 非必填
             * 处理结果为03-该票异常无法勾选时，根据实际情况反馈此码值
             * 1-成品油单价异常
             * 2-成品油超库存异常
             * 9-正常
             */
            @JSONField(name = "cpyycbs")
            private String oilAbnormalFlag;
        }
    }
}
