package com.xforceplus.taxware.leqi.kernel.contract.model.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvwenjing
 * @date 2023/4/21
 * @describe: 批量消费税代扣代缴完税凭证下载申请
 */
public class PostExciseTaxPaymentVoucherMessage {

    @Data
    public static class Request {

        /**
         * 被扣缴纳税人识别号
         * 长度：30
         */
        @JSONField(name = "bkjnsrsbh")
        private String taxNo;

        /**
         * 填发日期起
         * 长度：8:YYYYMMDD
         */
        @JSONField(name = "tfrqq")
        private String startDateIssued;

        /**
         * 填发日期止
         * 长度：8:YYYYMMDD
         */
        @JSONField(name = "tfrqz")
        private String endDateIssued;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号
         * 长度：32
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
