package com.xforceplus.taxware.leqi.kernel.contract.model.nscc.auth;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 获取授权码
 *
 * @author zhouwen
 * @date 2024-06-21 13:25
 */
public class PostAuthCodeMessage {

    @Data
    public static class Request {

        @JSONField(name = "qrcode_id")
        private String qrCodeId;
    }

    @Data
    public static class ResultData {

        /**
         * 二维码状态
         *   1 初始状态
         *   2 二维码扫描成功
         *   3 二维码已失效
         */
        @JSONField(name = "qrcode_status")
        private String qrCodeStatus;

        /**
         * 授权码
         *   当二维码状态为2时返回
         */
        private String code;

        /**
         * 授权码有效期止
         *   当二维码状态为2时返回
         *   格式: yyyy-MM-dd HH:mm:ss
         */
        private String endDate;
    }
}
