package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhenmengying
 * @date 2023/1/18
 * @describe: 查询纳税人基本信息
 */
public class PostTaxpayerInfoMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         * 开票纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 纳税人信息
         */
        @JSONField(name = "jcxx")
        private TaxpayerInfo taxpayer;

        @Data
        public static class TaxpayerInfo {
            /**
             * 纳税人识别号/统一社会信用代码
             */
            @JSONField(name = "nsrsbh")
            private String taxNo;

            /**
             * 登记序号（非必须）
             */
            @JSONField(name = "djxh")
            private String registerNo;

            /**
             * 税收档案编号（非必须）
             */
            @JSONField(name = "ssdabh")
            private String taxArchivesNo;

            /**
             * 纳税人名称
             */
            @JSONField(name = "nsrmc")
            private String taxpayerName;

            /**
             * 纳税人类型标签
             * 1：一般纳税人
             * 2：小规模纳税人
             * 3：转登记小规模纳税人
             * 4：辅导期一般纳税人
             * 5：自然人
             */
            @JSONField(name = "nsrlx")
            private String taxpayerTypeTag;

            /**
             * 生产经营地址
             */
            @JSONField(name = "scjydz")
            private String productionAddress;

            /**
             * 注册地邮政编码
             */
            @JSONField(name = "zcdyzbm")
            private String postalCode;

            /**
             * 注册地联系电话（非必须）
             */
            @JSONField(name = "zcdlxdh")
            private String registerTel;

            /**
             * 法人名称(法定代表人姓名）
             */
            @JSONField(name = "fddbrxm")
            private String legalPersonName;

            /**
             * 登记注册类型（国标，非必须）
             */
            @JSONField(name = "djzclxdm")
            private String registerType;

            /**
             * 行业代码
             * 主行业代码特定征收部门可空
             */
            @JSONField(name = "hydm")
            private String industryCode;

            /**
             * 区县级税务机关代码
             */
            @JSONField(name = "qxjswjgdm")
            private String countyTaxAuthorityCode;

            /**
             * 税务机关代码
             * 主管税务所科分局
             */
            @JSONField(name = "zgswskfjdm")
            private String chargeTaxDepartmentCode;

            /**
             * 税务机关名称
             * 主管税务所科分局
             */
            @JSONField(name = "zgswskfjmc")
            private String chargeTaxDepartmentName;

            /**
             * 财务负责人姓名
             */
            @JSONField(name = "cwfzrxm")
            private String financialDirectorName;

            /**
             * 账户名称
             */
            @JSONField(name = "khhmc")
            private String accountName;

            /**
             * 账号（非必须）
             * 首选账户账号
             */
            @JSONField(name = "yhzh")
            private String account;

            /**
             * 企业办税人员姓名（非必须）
             */
            @JSONField(name = "bsrxm")
            private String enterpriseTaxPersonnelName;

            /**
             * 数字化电子票试点企业标识
             * Y：数字化电子票试点企业
             * N：不是数字化电子票试点企业
             */
            @JSONField(name = "xdpsdqybz")
            private String allElectricFlag;

            /**
             * 出口企业分类
             * 空：非出口企业
             * 01：一类出口企业
             * 02：二类出口企业
             * 03：三类出口企业
             * 04：四类出口企业
             */
            @JSONField(name = "ckqyfldm")
            private String exportEnterprisesType;

            /**
             * 总分机构类型
             * 0：非总分机构
             * 1：总机构
             * 2：分支机构
             * 3：分总机构
             */
            @JSONField(name = "zfjglxdm")
            private String organizationType;

            /**
             * 银行营业网点（非必须）
             */
            @JSONField(name = "yhyywddm")
            private String bankBusinessOutlets;

            /**
             * 开票方纳税人状态
             * 01：受理
             * 02：筹建期
             * 03：正常
             * 04：停业
             * 05：非正常
             * 06：清算
             * 07：注销
             * 08：非正常户注销
             * 09：报验
             * 10：核销报验
             * 11：中断缴费
             * 12：恢复缴费
             * 13：简易注销无异议
             * 99：其他
             */
            @JSONField(name = "nsrztdm")
            private String sellerTaxpayerStatus;

            /**
             * 纳税人类型标签有效期起（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqq")
            private String startTaxpayerTypeFlagDate;

            /**
             * 纳税人类型标签有效期止（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqz")
            private String endTaxpayerTypeFlagDate;
        }

        /**
         * 企业行业性质
         */
        @JSONField(name = "qyhyxzGrid")
        private List<IndustryProperties> industryPropertiesList;

        /**
         * 消费税纳税人类型
         */
        @JSONField(name = "xfsnsrlxGrid")
        private List<ExciseTaxpayerType> exciseTaxpayerTypes;

        @Data
        public static class IndustryProperties {

            /**
             * 企业行业性质（非必须）
             * 01：成品油生产企业
             * 02：成品油经销企业
             * 03：国内机动车生产企业
             * 04：进口机动车生产企业驻我国办事机构或总授权代理机构
             * 05：机动车授权经销企业
             * 06：其他机动车贸易商
             * 07：二手车市场
             * 08：二手车经销企业
             * 09：二手车拍卖企业
             * 10：稀土矿产企业
             * 11：稀土冶炼分离企业
             * 12：稀土其他企业
             * 13：稀土矿产企业、稀土冶炼分离企业、稀土其他企业
             * 14：稀土矿产企业、稀土冶炼分离企业
             * 15：稀土矿产企业、稀土其他企业
             * 16：稀土冶炼分离企业、稀土其他企业
             * 17：卷烟生产企业
             * 18：卷烟批发企业
             * 19：卷烟出口企业
             * 20：生产型出口企业
             * 21：外贸型出口企业
             * 22：外贸综合服务企业
             * 23：自贸区试点企业
             * 24：特殊监管区内企业
             * 25：增值税一般纳税人资格试点
             * 26：市场采购试点
             * 27：退税商店
             * 28：电子商务出口企业
             * 29：享受出口退税政策的融资租赁企业
             * 30：增值税零税率应税服务提供者
             * 31：房地产开发企业
             * 32：农产品深加工企业
             * 33：外购石脑油、燃料油用于消费税退税企业
             * 34：从事机动车进口的其他贸易商
             * 35：自产农产品者
             * 36：农产品收购企业
             * 37：光伏收购企业
             * 38：住房租赁企业
             * 39：冬奥会退税企业
             */
            @JSONField(name = "qyhyxzdm")
            private String industryNatureProperties;

            /**
             * 有效期起（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqq")
            private String startIndustryPropertiesDate;

            /**
             * 有效期止（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqz")
            private String endIndustryPropertiesDate;
        }

        @Data
        public static class ExciseTaxpayerType {
            /**
             * 消费税纳税人类型（非必须）
             * 01：卷烟生产消费税纳税人
             * 02：卷烟批发消费税纳税人
             * 03：白酒生产消费税纳税人
             * 04：黄酒生产消费税纳税人
             * 05：啤酒生产消费税纳税人
             * 06：其他酒生产消费税纳税人
             * 07：小汽车生产消费税纳税人
             * 08：超豪华小汽车消费税纳税人
             * 09：汽油生产消费税纳税人
             * 10：石脑油生产消费税纳税人
             * 11：溶剂油生产消费税纳税人
             * 12：润滑油生产消费税纳税人
             * 13：柴油生产消费税纳税人
             * 14：航空煤油生产消费税纳税人
             * 15：燃料油生产消费税纳税人
             * 16：电池生产消费税纳税人
             * 17：涂料生产消费税纳税人
             * 18：高档化妆品生产消费税纳税人
             * 19：金银首饰铂金首饰和钻石及钻石饰品零售消费税纳税人
             * 20：其他贵重首饰和珠宝玉石生产消费税纳税人
             * 21：鞭炮焰火生产消费税纳税人
             * 22：摩托车生产消费税纳税人
             * 23：高尔夫球及球具生产消费税纳税人
             * 24：高档手表生产消费税纳税人
             * 25：游艇生产消费税纳税人
             * 26：木制一次性筷子生产消费税纳税人
             * 27：实木地板生产消费税纳税人
             * 28：雪茄烟生产消费税纳税人
             * 29：烟丝生产消费税纳税人
             */
            @JSONField(name = "xfsnsrlxdm")
            private String exciseTaxpayerType;

            /**
             * 有效期起（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqq")
            private String startExciseTypeDate;

            /**
             * 有效期止（非必须）
             * 格式：
             * yyyy-MM-dd
             */
            @JSONField(name = "yxqz")
            private String endExciseTypeDate;
        }
    }

}
