package com.xforceplus.taxware.leqi.kernel.contract.model.seller.style;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @Auther lv
 * @Date 2023/10/11
 * @Description 旅客运输特殊要素信息
 */
@Data
public class PassengerTransportations {

    /**
     * 出行人序号
     * Number
     * 8
     * 是
     */
    @JSONField(name = "cxrxh")
    private Integer rowNum;

    /**
     * 出行人
     * varchar
     * 20
     * 是
     */
    @JSONField(name = "cxr")
    private String travelers;

    /**
     *
     * 出行人证件类型
     * varchar
     * 20
     * 是
     * 100:单位 101:组织机构 代码证 102:营业执照 103:税务登记 证 199:其他单位 证件 200:个人 201:居民身份 证 202:军官证 203:武警警官证
     * 204:士兵证 205:军队离退 休干部证 206:残疾人证 207:残疾军人 证(1-8 级) 208:外国护照 209:港澳同胞 回乡证 210:港澳居民 来往内地通行 证 211:台胞证 212:中华人民 共和国往来港 澳通行证 213:台湾居民 来往大陆通行 证
     * 214:大陆居民 往来台湾通行 证 215:外国人居 留证 216:外交官证 217:使(领事) 馆证
     * 218:海员证 219:香港永久 性居民身份证 220:台湾身份 证 221:澳门特别 行政区永久性 居民身份证 222:外国人身 份证件 223:高校毕业 生自主创业证 224:就业失业 登记证 225:退休证 220:离休证 227:中国护照
     * 228:城镇退役 士兵自谋职业 证 229:随军家属 身份证明 230:中国人民 解放军军官转 业证书 231:中国人民 解放军义务兵 退出现役证 232:中国人民 解放军士官退 出现役证 233:外国人永 久居留身份证 (外国人永久 居留证)
     * 234:就业创业 证 235:香港特别 行政区护照 236:澳门特别 行政区护照 237:中华人民 共和国港澳居 民居住证 238:中华人民 共和国台湾居 民居住证 239:《中华人 民共和国外国 人工作许可 证》(A 类)
     * 240:《中华人 民共和国外国 人工作许可 证》(B 类) 241:《中华人 民共和国外国 人工作许可 证》(C 类) 291:出生医学 证明299:其他个人 证件
     */
    @JSONField(name = "cxrzjlxDm")
    private String travelerIdentityType;

    /**
     * 有效身份证件号
     * varchar
     * 20
     * 是
     */
    @JSONField(name = "sfzjhm")
    private String validIdNo;

    /**
     * 出行日期
     * date
     * 是
     * 格式:
     * yyyy-MM-dd
     */
    @JSONField(name = "chuxrq")
    private String travelDate;

    /**
     * 旅客出发地
     * varchar
     * 80
     * 是
     */
    @JSONField(name = "cfd")
    private String placeOfDeparture;

    /**
     * 旅客到达地
     * varchar
     * 80
     * 是
     */
    @JSONField(name = "ddd")
    private String destination;

    /**
     * 等级
     * varchar
     * 20
     * 是
     * 交通工具为 火车时: 一等座 二等座 软席(软座、 软卧) 硬席(硬座、 硬卧) 交通工作为 飞机时: 公务舱 头等舱 经济舱 交通工具为 船舶(不包括 旅游船)时: 一等舱 二等舱 三等舱
     */
    @JSONField(name = "zwdj")
    private String grade;

    /**
     * 交通工具类型
     * varchar
     * 80
     * 是
     * 1:飞机 2:火车 3:长途汽车 4:公共交通 5:出租车 6:汽车 7:船舶 9:其他
     */
    @JSONField(name = "jtgjlxDm")
    private String typeOfVehicle;

}
