package com.xforceplus.taxware.leqi.kernel.contract.model.seller.style;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author Thj
 * @createdAt: 2023/12/28 17:16
 * @Description:
 */
@Data
public class RealEstateSalesBothPurchaser {

    /**
     * 共同购买方
     */
    @JSONField(name = "gtgmf")
    private String bothPurchaser;

    /**
     * 证件类型
     * 100：单位
     * 101：组织机构代码证
     * 102：营业执照
     * 103：税务登记证
     * 199：其他单位证件
     * 200：个人
     * 201：居民身份证
     * 202：军官证
     * 203：武警警官证
     * 204：士兵证
     * 205：军队离退休干部证
     * 206：残疾人证
     * 207：残疾军人证（1-8级）
     * 208：外国护照
     * 209：港澳同胞回乡证
     * 210：港澳居民来往内地通行证
     * 211：台胞证
     * 212：中华人民共和国往来港澳通行证
     * 213：台湾居民来往大陆通行证
     * 214：大陆居民往来台湾通行证
     * 215：外国人居留证
     * 216：外交官证
     * 217：使（领事）馆证
     * 218：海员证
     * 219：香港永久性居民身份证
     * 220：台湾身份证
     * 221：澳门特别行政区永久性居民身份证
     * 222：外国人身份证件
     * 223：高校毕业生自主创业证
     * 224：就业失业登记证
     * 225：退休证
     * 226：离休证
     * 227：中国护照
     * 228：城镇退役士兵自谋职业证
     * 229：随军家属身份证明
     * 230：中国人民解放军军官转业证书
     * 231：中国人民解放军义务兵退出现役证
     * 232：中国人民解放军士官退出现役证
     * 233：外国人永久居留身份证（外国人永久居留证）
     * 234：就业创业证
     * 235：香港特别行政区护照
     * 236：澳门特别行政区护照
     * 237：中华人民共和国港澳居民居住证
     * 238：中华人民共和国台湾居民居住证
     * 239：《中华人民共和国外国人工作许可证》（A类）
     * 240：《中华人民共和国外国人工作许可证》（B类）
     * 241：《中华人民共和国外国人工作许可证》（C类）
     * 291：出生医学证明
     * 299：其他个人证件
     */
    @JSONField(name = "zjlx")
    private String identityType;

    /**
     * 证件号码
     */
    @JSONField(name = "zjhm")
    private String identityNo;
}
