package com.xforceplus.taxware.leqi.kernel.contract.model.supervision.alert;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lvwenjing
 * @date 2024/12/26
 * @describe: 使用单位红色预警检测（批量）
 */
public class PostUseUnitRedAlertBatchMessage {

    @Data
    public static class Request {

        /**
         * 业务类型 是
         * 红色预警-日常检测服务 HSYJ003 ok
         * 红色预警-开具发票阻断 HSYJ002
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 纳税人识别号 否
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 纳税人名称 否
         */
        @JSONField(name = "nsrlist")
        private List<String> taxNoList;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 批次流水号 String 32
         * 成功时，返回批次流水号，直连单位可以通过批次流水号查询资格预检结果
         * 失败时，不返回，直连单位可重新发起批量预检查询
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
