package com.xforceplus.taxware.leqi.kernel.contract.model.supervision.alert;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lvwenjing
 * @date 2024/12/26
 * @describe: 使用单位红色预警检测（单户）
 */
public class PostUseUnitRedAlertMessage {

    @Data
    public static class Request {

        /**
         * 业务类型 是
         * 红色预警-日常检测服务 HSYJ003
         * 红色预警-开具发票阻断 HSYJ002  ok
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 纳税人识别号 否
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 纳税人名称 否
         */
        @JSONField(name = "nsrmc")
        private String taxpayerName;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 业务类型 是
         * 红色预警-日常检测服务 HSYJ003
         * 红色预警-开具发票阻断 HSYJ002
         */
        @JSONField(name = "ywlx")
        private String businessType;

        /**
         * 纳税人识别号 否
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 纳税人名称 否
         */
        @JSONField(name = "nsrmc")
        private String taxpayerName;
        /**
         * 主管税务机关名称
         * 是
         */
        @JSONField(name = "zgswjgmc")
        private String chargeTaxAuthorityName;

        /**
         * 红色预警标志 String 1 是 Y：是，存在红色预警 N：否
         */
        @JSONField(name = "hsyjbz")
        private String redAlertFlag;
    }
}
