package com.xforceplus.taxware.leqi.kernel.contract.model.unit;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import com.xforceplus.taxware.leqi.kernel.contract.model.seller.PostInvoiceUploadMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/7/22
 * @describe: 查询使用单位接入状态接口
 */
public class PostUseUnitAccessStatusMessage {

    @Data
    public static class Request {

        /**
         * 页码（必须）
         */
        @JSONField(name = "pageNumber")
        private Integer pageNumber = 1;

        /**
         * 每页数量（必须）
         * 分页查询-待 查询页大小 大于等于 1 且 小于等于 100 的整数
         */
        @JSONField(name = "pageSize")
        private Integer pageSize = 20;

        /**
         * 接入状态
         * 否
         */
        @JSONField(name = "ztbm")
        private String accessStatus;

        /**
         * 使用单位信息
         * 否
         */
        @JSONField(name = "sydwxx")
        private List<UseUnit> useUnits;

        @Data
        public static class UseUnit {

            /**
             * 使用单位纳税人 识别号/统一社会 信用代码
             * 20
             * 是
             */
            @JSONField(name = "sydwshxydm")
            private String taxNo;

            /**
             * 省市级税务机关 代码
             * 20
             * 是
             */
            @JSONField(name = "ssjswjgDm")
            private String provincialTaxAuthorityCode;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 页码（必须）
         */
        @JSONField(name = "pageNumber")
        private Integer pageNumber;

        /**
         * 每页数量（必须）
         */
        @JSONField(name = "pageSize")
        private Integer pageSize;

        /**
         * 总记录数
         * 10
         * 是
         */
        @JSONField(name = "total")
        private Integer total;

        /**
         * 使用单位列表
         */
        @JSONField(name = "sydwList")
        private List<UseUnitResult> useUnitList;

        @Data
        public static class UseUnitResult {

            /**
             * 使用单位登记序 号 20
             * 是
             */
            @JSONField(name = "sydwdjxh")
            private String registerNo;

            /**
             * 使用单位纳税人 识别号/统一社会 信用代码 20
             * 是
             */
            @JSONField(name = "sydwshxydm")
            private String taxNo;

            /**
             * 使用单位纳税人 名称 300
             * 是
             */
            @JSONField(name = "sydwnsrmc")
            private String taxpayerName;

            /**
             * 邀请时间-时间格 式:”yyyy-MM-dd HH:mm:ss ”
             * 是
             */
            @JSONField(name = "yqsj")
            private String inviteTime;

            /**
             * 接入时间 -时间格 式:”yyyy-MM-dd HH:mm:ss ”
             * 是
             */
            @JSONField(name = "jrsj")
            private String accessTime;

            /**
             * 接入状态 2
             * 是
             */
            @JSONField(name = "ztbm")
            private String accessStatus;

            /**
             * 乐企ID - 接入状态为 “已确认”时， 必填。
             * 20
             * 否
             */
            @JSONField(name = "lqdwid")
            private String nsId;

            /**
             * 省市级税务机关 代码
             * 20
             * 是
             */
            @JSONField(name = "ssjswjgDm")
            private String provincialTaxAuthorityCode;

            /**
             * 省市级税务机关 名称
             * 300
             * 是
             */
            @JSONField(name = "ssjswjgmc")
            private String provincialTaxAuthorityName;

            /**
             * 主管税务机关代码 20
             * 是
             */
            @JSONField(name = "zgswjgDm")
            private String chargeTaxAuthorityCode;

            /**
             * 主管税务机关名称 300
             * 是
             */
            @JSONField(name = "zgswjgmc")
            private String chargeTaxAuthorityName;

            /**
             * 与直连单位关系
             * 是
             * 枚举值: 00-无关系、 01-总分公司 关系、 02-母子公司 关系、 03-其他控制 关系、04-不具有控 制关系、 05-同一监管 部门
             */
            @JSONField(name = "dwgxDm")
            private String relationshipType;

            /**
             * 能力授权情况
             */
            @JSONField(name = "nlsqqk")
            private List<Capability> capabilityList;

            @Data
            public static class Capability {

                /**
                 * 能力授权状态代 码
                 * 是
                 * 1
                 * 1:已授权 2:未授权 3:待确认(直 连单位向使用 单位发起能力 授权邀请) 4:待确认邀请 (使用单位向 直连单位发起 能力授权申 请)
                 */
                @JSONField(name = "nlsqztDm")
                private String capabilityAccessStatus;

                /**
                 * 能力编码
                 */
                @JSONField(name = "nlbm")
                private String capabilityCode;

                /**
                 * 能力名称
                 */
                @JSONField(name = "nlmc")
                private String capabilityName;

                /**
                 * 能力授期有效期 起 时间格式: YYYY-MM-DD
                 * 是
                 */
                @JSONField(name = "yxqq")
                private String startDate;

                /**
                 * 能力授期有效期 止 时间格式: YYYY-MM-DD
                 * 是
                 */
                @JSONField(name = "yxqz")
                private String endDate;

            }
        }
    }
}
