package com.xforceplus.taxware.leqi.kernel.contract.model.unit;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lvwenjing
 * @date 2023/7/22
 * @describe: 查询使用单位授权认证信息
 */
public class PostUseUnitAuthInfoMessage {

    @Data
    public static class Request {

        /**
         * 使用单位社会信 用代码 否
         */
        @JSONField(name = "sydwshxydm")
        private String taxNo;

        /**
         * 使用单位纳税人 名称 否
         */
        @JSONField(name = "sydwnsrmc")
        private String taxpayerName;

        /**
         * 页码（必须）
         */
        @JSONField(name = "pageNumber")
        private Integer pageNumber = 1;

        /**
         * 每页数量（必须）
         */
        @JSONField(name = "pageSize")
        private Integer pageSize = 20;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 页码（必须）
         * 是
         */
        @JSONField(name = "pageNumber")
        private Integer pageNumber;

        /**
         * 每页数量（必须）
         * 是
         */
        @JSONField(name = "pageSize")
        private Integer pageSize;

        /**
         * 总记录数
         * 是
         * 10
         */
        @JSONField(name = "total")
        private Integer total;

        /**
         * 授权认证明细
         * 否
         */
        @JSONField(name = "sqrzmx")
        private List<AuthInfo> authInfoList;

        @Data
        public static class AuthInfo {
            /**
             * 使用单位登记序 号 20
             * 是
             */
            @JSONField(name = "sydwdjxh")
            private String registerNo;

            /**
             * 使用单位纳税人 识别号/统一社会 信用代码 20
             * 是
             */
            @JSONField(name = "sydwshxydm")
            private String taxNo;

            /**
             * 使用单位纳税人 名称 300
             * 是
             */
            @JSONField(name = "sydwnsrmc")
            private String taxpayerName;

            /**
             * 授权认证标志Y:已授权认证 N:未授权认证
             * 1
             * 是
             */
            @JSONField(name = "sydwnsrmc")
            private String authFlag;

            /**
             * 授权码
             * 64
             * 否
             */
            @JSONField(name = "sqm")
            private String authCode;

            /**
             * 授权认证有效期止 YYYY-MM-DD HH:mm:ss
             * 否
             * 19
             */
            @JSONField(name = "sqrzyxqz")
            private String endDate;
        }
    }
}
