package com.xforceplus.taxware.leqi.kernel.contract.model.base.voucher;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/11/15
 * @Description 海关缴款书
 */
@Data
public class CustomsPayment {

    /**
     * 海关缴款书号码
     * 必填
     * 75
     */
    @JSONField(name = "hgjkshm")
    private String customsPaymentNo;

    /**
     * 填发日期
     * 长度：19 YYYY-MM-DD HH:mm:ss
     */
    @JSONField(name = "tfrq")
    private String dateTimeIssued;

    /**
     * 缴款单位人识纳税人别号
     * 长度：20
     */
    @JSONField(name = "kjywrsbh")
    private String taxNo;

    /**
     * 缴款单位人识纳税人名称
     * 长度：300
     */
    @JSONField(name = "kjywrmc")
    private String taxName;

    /**
     * 税款金额
     * DECIMAL：18,2
     */
    @JSONField(name = "skje")
    private String taxAmount;

    /**
     * 是否重号锁定
     * 长度：1
     * 非必需
     * Y:锁定 N:未锁定
     */
    @JSONField(name = "sfchsd")
    private String blockStatus;

    @JSONField(name = "hwxx")
    private List<Detail> detailList;

    @Data
    public static class Detail {

        /**
         * 税号信息
         * 长度：22
         * 必需
         */
        @JSONField(name = "shdm")
        private String taxNo;

        /**
         * 完税价格
         * 必需
         * 15,2
         */
        @JSONField(name = "wsjg")
        private BigDecimal amountWithoutTax;

        /**
         * 税款金额
         * 必需
         * 15,2
         */
        @JSONField(name = "skje")
        private BigDecimal taxAmount;

        /**
         * 货物名称
         * 长度：45
         * 必需
         */
        @JSONField(name = "hwmc")
        private String itemName;

        /**
         * 数量
         * 15,5
         * 非必需
         */
        @JSONField(name = "sl")
        private String quantity;

        /**
         * 单位
         * 长度：6
         * 非必需
         */
        @JSONField(name = "dw")
        private String unit;

        /**
         * 税率
         * 15,5
         * 必需
         */
        @JSONField(name = "hwslv")
        private BigDecimal taxRate;
    }
}
