package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 查询海关缴款书抵扣勾选处理结果
 */
public class PostCustomsPaymentDeductionUploadResult {
    @Data
    public static class Request {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 非必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：20
         * 非必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "hgjksmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 缴款书号码
             * 长度：22
             * 必填
             */
            @JSONField(name = "jkshm")
            private String customsPaymentNo;

            /**
             * 出口转内销证明编号
             * 长度：30
             * 非必填
             * 如为出口转内销需上传转内销证明编号
             */
            @JSONField(name = "ckznxzmbh")
            private String exportToDomesticSalesCertificateNo;

            /**
             * 填发日期
             * 长度：8
             * 必填
             * YYYYMMDD
             */
            @JSONField(name = "tfrq")
            private String dateIssued;

            /**
             * 税款所属期
             * 格式YYYYMM，退税成功时该字段不为空
             * 长度：6
             * 非必填
             */
            @JSONField(name = "skssq")
            private String taxPeriod;

            /**
             * 处理结果
             * 长度：1
             * 非必填
             * 01- 勾选（撤销）成功
             * 02-查无此票
             * 03-该票异常无法勾选
             * 04-该票已经逾期无法认证
             * 05-当期已锁定（已申请统计）
             * 06-已勾选无法重复勾选
             * 07-未到期不可勾选（填发月份大于当前属期）
             * 13：该票号码重复99-其它
             */
            @JSONField(name = "cljg")
            private String returnStatus;

            /**
             * 勾选时间
             * 长度：8
             * 非必填
             * 撤销勾选时，此字段为空
             * YYYYMMDD
             */
            @JSONField(name = "gxsj")
            private String deductionDate;

            /**
             * 当前勾选用途
             * 长度：2
             * 非必填
             * 重复勾选“时，根据实际情况反馈此码值。
             * 1 已申请抵扣
             * 2 已申请退税
             * 3 已申请代办退税
             * 4 已勾选不抵扣（历史数据）
             * 5 已申请代办退税（历史数据）
             * 6 已申请不抵扣
             * 11 冬奥退税
             */
            @JSONField(name = "hxyt")
            private String deductionPurpose;
        }
    }
}
