package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/7/7
 * @Description 申请确认抵扣统计
 */
public class PostDeductionStatisticsConfirmApply {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 非必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 申请标志
         * 长度：1
         * 必需
         * 1：申请统计
         * 2：撤销统计
         */
        @JSONField(name = "sqbz")
        private String applyFlag;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 非必需
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
