package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 批量上传税务机关代开农产品发票补录信息
 */
public class PostInvoiceAgriculturalProductsDeputyUpload {
    @Data
    public static class Request {

        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "fpmx")
        private List<Detail> details;

        @Data
        public static class Detail {

            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 发票类型
             * 长度：2
             * 必填
             * 农产品类型为
             * 01：增值税专用发票
             * 04：增值税普通发票
             * 08：增值税电子专用发票
             * 10：增值税电子普通发票
             * 81：电子发票（增值税专用发票）
             * 82：电子发票（普通发票，特定要素类型码值为 08 的通行费发票；特定要素为 12 或 16 的农产品发票）
             * 85：纸质发票（增值税专用发票）
             * 86：纸质发票（普通发票，特定要素为 12 或 16 的农产品发票）
             * */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 有效抵扣税额
             * 非必填
             */
            @JSONField(name = "yxdkse")
            private BigDecimal effectiveTaxAmount;

            /**
             * 农产品部分金额
             * 非必填
             */
            @JSONField(name = "ncpbfje")
            private BigDecimal agriculturalProductsAmountWithoutTax;

            /**
             * 农产品部分税额
             * 非必填
             */
            @JSONField(name = "ncpbfse")
            private BigDecimal agriculturalProductsTaxAmount;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 非必填
         * 返回码不是 00：成功时，不返回
         */
        @JSONField(name = "pclsh")
        private String taskId;

        @JSONField(name = "fpmx")
        private List<Detail> details;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 上传状态
             * 长度：2
             * 必需
             * 00：成功
             * 01：失败
             */
            @JSONField(name = "sczt")
            private String uploadStatus;

            /**
             * 错误码
             * 长度：2000
             * 非必须
             * 上传状态为 01：失败时记录失败原因
             */
            @JSONField(name = "errormsg")
            private String errorMsg;
        }
    }
}
