package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.deduction;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 查询发票农产品商品编码列表
 */
public class PostInvoiceAgriculturalProductsTaxCode {
    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 总数量
         * 非必填
         * 有数据时返回
         */
        @JSONField(name = "zsl")
        private Integer total;

        @JSONField(name = "fpspbmlb")
        private List<Detail> taxRateList;

        @Data
        public static class Detail {
            /**
             * 商品编码
             * 长度：20
             */
            @JSONField(name = "spbm")
            private String goodsTaxNo;

            /**
             * 商品和服务名称
             * 长度：300
             */
            @JSONField(name = "sphfwmc")
            private String itemSimpleName;

            /**
             *  税收分类编码
             *  长度：20
             */
            @JSONField(name = "ssflbm")
            private String taxCode;
        }
    }
}
