package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.entry;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Auther lv
 * @Date 2023/11/15
 * @Description 批量上传入账发票
 */
public class PostInvoiceEntryUpload {

    @Data
    public static class Request {
        /**
         * 购买方统一社会信用代码/纳税人识别号
         * 长度：30
         * 必填
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        @JSONField(name = "fpmx")
        private List<Detail> detailList;

        @Data
        public static class Detail {
            /**
             * 开票日期
             * 长度：8
             * 格式: YYYYMMDD
             * 必填
             */
            @JSONField(name = "kprq")
            private String dateIssued;

            /**
             * 发票代码
             * 全电发票发票代码可为空
             * 长度：12
             * 非必填
             */
            @JSONField(name = "fpdm")
            private String invoiceCode;

            /**
             * 发票号码
             * 全电发票，发票号码20位
             * 长度：20
             * 必填
             */
            @JSONField(name = "fphm")
            private String invoiceNo;

            /**
             * 入账属期
             * 格式为：YYYYMM。当“申请勾选类型”为“02”,“03”,“04”,“05”时入账属期必填，“06”无需填写。
             * 长度：20
             * 必填
             */
            @JSONField(name = "skssq")
            private String period;

            /**
             * 发票类型
             * 长度：2
             * 必填
             * 01-增值税专用发票
             * 02-货物运输业增值税专用发票
             * 03-机动车销售统一发票
             * 04-增值税普通发票
             * 08-增值税电子专用发票
             * 10-增值税电子普通发票
             * 11-卷式发票
             * 14-通行费发票
             * 15-二手车销售统一发票
             * 81-电子发票（增值税专用发票）
             * 82-电子发票（普通发票）
             * 83-机动车销售电子统一发票
             * 84-二手车销售电子统一发票
             * 85-纸质发票（增值税专用发票）
             * 86-纸质发票（普通发票）
             * 87-纸质发票（机动车销售统一发票）
             * 88-纸质发票（二手车销售统一发票）
             * 61-电子发票（航空运输客票电子行程单）
             * 51-电子发票（铁路电子客票）
             * */
            @JSONField(name = "fplx")
            private String invoiceType;

            /**
             * 申请勾选类型
             * 02：入账（企业所得税税前扣除）
             * 03：入账（企业所得税不扣除）
             * 04：入账（个人所得税经营所得税前扣除）
             * 05：入账（个人所得税经营所得不扣除）
             * 06：入账撤销
             * 长度：1
             * 必填
             */
            @JSONField(name = "sqgxlx")
            private String deductionType;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {
        /**
         * 批次流水号
         * 长度：32
         * 必填
         */
        @JSONField(name = "pclsh")
        private String taskId;
    }
}
