package com.xforceplus.taxware.leqi.kernel.contract.model.buyer.refund;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Auther lv
 * @Date 2023/8/1
 * @Description 未勾选数据初始化清单下载申请反馈-退税
 */
public class PostTaxRefundUncheckInitResult {
    @Data
    public static class Request {
        /**
         * 批次流水号
         * 长度：32
         * 必需
         */
        @JSONField(name = "pclsh")
        private String taskId;

        /**
         * 包号
         * 长度:5
         * 必填
         * 数据包号，当数据量过大时会进行分包处理,初始包号为1
         */
        @JSONField(name = "packageno")
        private String packageNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 当前流水号下的总包数
         * 长度：5
         * 必需
         */
        @JSONField(name = "packagecount")
        private String packageCount;

        /**
         * 购方纳税人识别号/统一社会信用代码
         * 长度：30
         * 必需
         */
        @JSONField(name = "gfsbh")
        private String taxNo;

        /**
         * 处理结果
         * 长度：1
         * 必填
         * 1：成功
         * 2：不存在符合条件的发票
         * 3：失败
         */
        @JSONField(name = "cljg")
        private String returnStatus;

        /**
         * 数据流
         * 非必填
         * 压缩包文件流（gzip+base64），原始数据为 json 报文
         * Json 报文格式
         * 详见：附件二 （未勾选数据初始化清单信息数据说明）
         */
        @JSONField(name = "sjl")
        private String returnData;
    }
}
