package com.xforceplus.taxware.leqi.kernel.contract.model.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/3/3
 */
@Getter
public enum NaturalSystemEnums {

    //=========开票===========
    /**
     * 查询纳税人基本信息
     */
    TAXPAYER_INFO("taxpayerInfo", "CXNSRJBXX"),
    /**
     * 查询纳税人风险信息
     */
    TAXPAYER_RISK_INFO("taxpayerRisk", "CXNSRFXXX"),
    /**
     * 查询可用税率信息
     */
    TAX_RATE_INFO("taxRate", "CXKYSL"),
    /**
     * 查询税收分类编码信息
     */
    TAX_CODE_INFO("taxCode", "CXSSFLBM"),
    /**
     * 查询差额征税税收分类编码
     */
    DIFFERENCE_TAX_CODE_INFO("differenceTaxCode", "CXCEZSBM"),
    /**
     * 查询授信额度
     */
    CREDIT_LINE("creditLine", "CXSXED"),
    /**
     * 下载/退回授信额度
     */
    DOWNLOAD_CREDIT_LINE("downloadSendBackCreditLine", "XZTHSXED"),
    /**
     * 调整授信额度有效期
     */
    CREDIT_LINE_PERIOD("creditLinePeriod", "TZSXEDYXQ"),
    /**
     * 获取全电发票批量预赋码信息
     */
    INVOICE_NO_SEGMENT("invoiceNoSegment", "QDFPPLFM"),
    /**
     * 全电发票上传
     */
    INVOICE_UPLOAD("invoiceUpload", "QDFPSC"),
    /**
     * 查询全电发票上传结果
     */
    INVOICE_UPLOAD_RESULT("invoiceUploadResult", "CXQDFPSCJG"),
    /**
     * 全电发票上传--成品油
     */
    INVOICE_UPLOAD_OIL("invoiceUploadOil", "QDFPSC_CPY"),
    /**
     * 查询全电发票上传结果--成品油
     */
    INVOICE_UPLOAD_OIL_RESULT("invoiceUploadOilResult", "CXQDFPSCJG_CPY"),
    /**
     * 全电发票上传--货物运输服务
     */
    INVOICE_UPLOAD_FREIGHT("invoiceUploadFreight", "HWYSFPSC"),
    /**
     * 查询全电发票上传结果--不动产租赁
     */
    INVOICE_UPLOAD_ESTATE_LEASE("invoiceUploadEstateLease", "BDCJYZLFPSC"),
    /**
     * 全电发票上传--不动产销售
     */
    INVOICE_UPLOAD_ESTATE_SALES("invoiceUploadEstateSales", "QDFPSC_BDCXS"),
    /**
     * 查询全电发票上传结果--农产品收购
     */
    INVOICE_UPLOAD_PRODUCE_PURCHASE("invoiceUploadProducePurchase", "NCPSGFPSC"),
    /**
     * 查询全电发票上传结果--农产品销售
     */
    INVOICE_UPLOAD_PRODUCE_SALES("invoiceUploadProduceSales", "NCPXSFPSC"),
    /**
     * 查询全电发票上传结果--建筑服务发票上传
     */
    INVOICE_UPLOAD_BUILDING_SERVICE_INFO("invoiceUploadBuildingServiceInfo", "QDFPSC_JZFW"),
    /**
     * 全电红字确认单申请
     */
    RED_LETTER_APPLY("redLetterApply", "QDHZQRDSQ"),
    /**
     * 全电红字确认单确认
     */
    RED_LETTER_CONFIRM("redLetterConfirm", "QDHZQRDQR"),
    /**
     * 查询全电红字确认单列表查询
     */
    RED_LETTER_LIST("redLetterList", "CXQDHZQRDLB"),
    /**
     * 查询全电红字确认单明细查询
     */
    RED_LETTER_DETAIL("redLetterDetail", "CXQDHZQRDMX"),
    /**
     * 上传发票汇总确认信息
     */
    INVOICE_SUMMARY_UPLOAD("invoiceSummaryUpload", "SCFPHZQRXX"),
    /**
     * 查询发票汇总确认信息
     */
    INVOICE_SUMMARY_QUERY("invoiceSummaryQuery", "CXFPHZQRXX"),
    /**
     * 发票用途状态信息查询
     */
    INVOICE_PURPOSE_STATUS_FOR_MAKE("invoicePurposeStatusForMake", "FPZTXXCX"),

    //=========开票-成品油===========
    /**
     * 查询成品油可用税收分类编码信息
     */
    OIL_TAX_CODE_INFO("oilTaxCode", "CXCPYKYSSFLBM"),
    /**
     * 查询成品油库存
     */
    OIL_INVENTORY("oilInventory", "CXCPYKC"),
    /**
     * 下载或退回成品油库存
     */
    DOWNLOAD_OIL_INVENTORY("oilInventoryDownloadSendBack", "XZHTHCPYKC"),
    //=========开票-不动产销售=======
    /**
     * 查询房源信息
     */
    PROPERTY_INFO("propertyInfo", "CXFYXX"),
    //=========开票-建筑服务=======
    /**
     * 查询建筑服务信息
     */
    BUILDING_SERVICE_INFO("buildingServiceInfo", "CXJZFWXX"),
    //=========开票-金银首饰=======
    /**
     * 查询是否为试点地区企业
     */
    JEWELRY_PILOT("jewelryPilot", "CXGFSFWSDDQQY"),
    /**
     * 查询金银首饰经营企业资格
     */
    JEWELRY_QUALIFICATION("jewelryQualification", "CXJYSSJYQYZG"),
    /**
     * 全电发票上传--金银首饰发票上传
     */
    INVOICE_UPLOAD_JEWELRY("invoiceUploadJewelry", "JYSSFPSC"),
    //=========用票-归集===========
    /**
     * 全电发票xml文件下载
     */
    INVOICE_XML("invoiceXml", "FPWJSQXZ"),
    /**
     * 全电发票xml文件下载结果
     */
    INVOICE_XML_RESULT("invoiceXmlResult", "FPWJSQJGFK"),
    /**
     * 发票风险状态信息查询
     */
    INVOICE_RISK_STATUS("invoiceRiskStatus", "FPTSTXXXCX"),
    /**
     * 发票用途状态信息查询
     */
    INVOICE_PURPOSE_STATUS("invoicePurposeStatus", "FPZTXXCX"),
    /**
     * 发票批量下载
     */
    INVOICE_DOWNLOAD("invoiceDownload", "PLFPXZSQ"),
    /**
     * 发票批量下载结果
     */
    INVOICE_DOWNLOAD_RESULT("invoiceDownloadResult", "PLFPXZSQFK"),
    /**
     * 发票增量下载
     */
    INVOICE_DOWNLOAD_INCREMENT("invoiceDownloadIncrement", "CXZLXZFPXX"),
    /**
     * 批量出口转内销发票信息查询
     */
    EXPORT_TO_DOMESTIC_SALES_INVOICE("exportToDomesticSalesInvoice", "PLCKZNXFPXXCX"),
    /**
     * 批量出口转内销海关缴款书信息查询
     */
    EXPORT_TO_DOMESTIC_SALES_CUSTOMS_PAYMENT("exportToDomesticSalesCustomsPayment", "PLCKZNXHGJKSXXCX"),
    /**
     * 批量增值税代扣代缴完税凭证下载申请
     */
    VAT_TAX_PAYMENT_VOUNCHER("vatTaxPaymentVoucher", "PLZZSDKDJWSPZXZSQ"),
    /**
     * 批量增值税代扣代缴完税凭证下载申请反馈
     */
    VAT_TAX_PAYMENT_VOUNCHER_RESULT("vatTaxPaymentVoucherResult", "PLZZSDKDJWSPZXZSQFK"),
    /**
     * 查询增量下载增值税代扣代缴完税凭证信息
     */
    VAT_TAX_PAYMENT_VOUNCHER_INCREMENT("vatTaxPaymentVoucherIncrement", "CXZLXZZZSDKDJWSPZXX"),
    /**
     * 批量消费税代扣代缴完税凭证下载申请
     */
    EXCISE_TAX_PAYMENT_VOUCHER("exciseTaxPaymentVoucher", "PLXFSDKDJWSPZXZSQ"),
    /**
     * 批量消费税代扣代缴完税凭证下载申请反馈
     */
    EXCISE_TAX_PAYMENT_VOUCHER_RESULT("exciseTaxPaymentVoucherResult", "PLXFSDKDJWSPZXZSQFK"),
    /**
     * 查询增量下载消费税代扣代缴完税凭证信息
     */
    EXCISE_TAX_PAYMENT_VOUCHER_INCREMENT("exciseTaxPaymentVoucherIncrement", "CXZLXZXFSDKDJWSPZXX"),
    /**
     * 批量海关缴款书下载申请
     */
    CUSTOMS_PAYMENT("customsPayment", "PLHGJKSXZSQ"),
    /**
     * 批量海关缴款书下载申请反馈
     */
    CUSTOMS_PAYMENT_RESULT("customsPaymentResult", "PLHGJKSXZSQFK"),
    /**
     * 查询增量下载海关缴款书信息
     */
    CUSTOMS_PAYMENT_INCREMENT("customsPaymentIncrement", "CXZLXZHGJKSXX"),

    //=========用票-抵扣勾选===========
    /**
     * 获取当前税款所属期与当期税款所属期统计状态
     */
    TAX_PERIOD("taxPeriod", "HQDQSKSSQYDQSKSSQTJZT"),
    /**
     * 批量发票抵扣勾选
     */
    INVOICE_DEDUCTION_UPLOAD("invoiceDeductionUpload", "PLFPDKGX"),
    /**
     * 查询发票抵扣勾选处理结果
     */
    INVOICE_DEDUCTION_UPLOAD_RESULT("invoiceDeductionUploadResult", "CXFPDKGXCLJG"),
    /**
     * 批量海关缴款书抵扣勾选
     */
    CUSTOMS_PAYMENT_DEDUCTION_UPLOAD("customsPaymentDeductionUpload", "PLHGJKSDKGX"),
    /**
     * 查询海关缴款书抵扣勾选处理结果
     */
    CUSTOMS_PAYMENT_DEDUCTION_UPLOAD_RESULT("customsPaymentDeductionUploadResult", "CXHGJKSDKGXCLJG"),
    /**
     * 申请撤销抵扣统计
     */
    DEDUCTION_STATISTICS_APPLY("deductionStatisticsApply", "SQCXDKTJ"),
    /**
     * 查询申请撤销统计处理结果
     */
    DEDUCTION_STATISTICS_APPLY_RESULT("deductionStatisticsApplyResult", "CXTJCLJG"),
    /**
     * 申请确认抵扣统计
     */
    DEDUCTION_STATISTICS_CONFIRM_APPLY("deductionStatisticsConfirmApply", "SQQRDKTJ"),
    /**
     * 查询确认统计处理结果
     */
    DEDUCTION_STATISTICS_CONFIRM_APPLY_RESULT("deductionStatisticsConfirmApplyResult", "CXQRTJCLJG"),
    /**
     * 获取当前税款所属期发票抵扣勾选处理结果
     */
    CURRENT_TAX_PERIOD_INVOICE_DEDUCTION("currentTaxPeriodInvoiceDeduction", "HQDQSKSSQFPDKGXCLJG"),
    /**
     * 获取当前税款所属期海关缴款书抵扣勾选处理结果
     */
    CURRENT_TAX_PERIOD_CUSTOMS_PAYMENT_DEDUCTION("currentTaxPeriodCustomsPaymentDeduction", "HQDQSKSSQHGJKSDKGXCLJG"),
    /**
     * 批量上传增值税代扣代缴完税凭证抵扣勾选
     */
    VAT_TAX_PAYMENT_VOUCHER_DEDUCTION_UPLOAD("vatTaxPaymentVoucherDeductionUpload", "PLSCZZSDKDJWSPZDKGX"),
    /**
     * 查询增值税代扣代缴完税凭证抵扣勾选处理结果
     */
    VAT_TAX_PAYMENT_VOUCHER_DEDUCTION_UPLOAD_RESULT("vatTaxPaymentVoucherDeductionUploadResult", "CXZZSDKDJWSPZDKGXCLJG"),
    /**
     * 获取当前税款所属期代扣代缴完税凭证抵扣勾选处理结果
     */
    CURRENT_VAT_TAX_PAYMENT_VOUCHER_DEDUCTION("currentVatTaxPaymentVoucherDeduction", "HQDQSKSSQDKDJWSPZDKGXCLJG"),
    /**
     * 未勾选数据初始化清单下载申请-抵扣
     */
    DEDUCTION_UNCHECK_INIT("deductionUncheckInit", "WGXSJCSHQDXZSQDKGX"),
    /**
     * 未勾选数据初始化清单下载申请反馈-抵扣
     */
    DEDUCTION_UNCHECK_INIT_RESULT("deductionUncheckInitResult", "WGXSJCSHQDXZSQFKDKGX"),
    /**
     * 批量上传待处理农产品发票确认清单
     */
    INVOICE_AGRICULTURAL_PRODUCTS_TO_BE_PROCESSED_UPLOAD("invoiceAgriculturalProductsToBeProcessedUpload", "PLSCDCLNCPFPQRQD"),
    /**
     * 查询批量上传待处理农产品发票确认清单处理结果
     */
    INVOICE_AGRICULTRUAL_PRODUCTS_TO_BE_PROCESSED_UPLOAD_RESULT("invoiceAgriculturalProductsToBeProcessedUploadResult", "CXPLSCDCLNCPFPQRQDCLJG"),
    /**
     * 批量上传税务机关代开农产品发票补录信息
     */
    INVOICE_AGRICULTURAL_PRODUCTS_DEPUTY_UPLOAD("invoiceAgriculturalProductsDeputyUpload", "PLSCSWJGDKNCPFPBLXX"),
    /**
     * 查询批量上传税务机关代开农产品发票补录信息处理结果
     */
    INVOICE_AGRICULTRUAL_PRODUCTS_DEPUTY_UPLOAD_RESULT("invoiceAgriculturalProductsDeputyUploadResult", "CXPLSCSWJGDKNCPFPBLXXCLJG"),
    /**
     * 查询发票农产品商品编码列表
     */
    INVOICE_AGRICULTURAL_PRODUCTS_TAX_CODE("invoiceAgriculturalProductsTaxCode", "CXFPNCPSPBMLB"),
    /**
     * 汇总纳税人机构列表查询
     */
    SUMMARY_TAXPAYER("summaryTaxpayer", "HZNSRJGLBCX"),
    /**
     * 总分机构汇总勾选确认
     */
    SUMMARY_CONFIRM("summaryConfirm", "ZFJGHZGXQR"),
    /**
     * 申请税款所属期变更
     */
    TAX_PERIOD_CHANGE("taxPeriodChange", "SQSKSSQBG"),
    /**
     * 申请注销勾选
     */
    CANCLE_CHECK("cancelCheck", "SQZXGX"),

    //=========用票-退税勾选===========
    /**
     * 批量发票退税勾选确认
     */
    INVOICE_TAX_REFUND_UPLOAD("invoiceTaxRefundUpload", "PLFPTSGXQR"),
    /**
     * 查询发票退税勾选确认处理结果
     */
    INVOICE_TAX_REFUND_UPLOAD_RESULT("invoiceTaxRefundUploadResult", "CXFPTSGXQRCLJG"),
    /**
     * 批量海关缴款书退税勾选确认
     */
    CUSTOMS_PAYMENT_TAX_REFUND_UPLOAD("customsPaymentTaxRefundUpload", "PLHGJKSTSGXQR"),
    /**
     * 查询海关缴款书退税勾选确认处理结果
     */
    CUSTOMS_PAYMENT_TAX_REFUND_UPLOAD_RESULT("customsPaymentTaxRefundUploadResult", "CXHGJKSTSGXQRCLJG"),
    /**
     * 未勾选数据初始化清单下载申请-退税
     */
    TAX_REFUND_UNCHECK_INIT("taxRefundUncheckInit", "WGXSJCSHQDXZSQTSGX"),
    /**
     * 未勾选数据初始化清单下载申请结果反馈-退税
     */
    TAX_REFUND_UNCHECK_INIT_RESULT("taxRefundUncheckInitResult", "WGXSJCSHQDXZSQFKTSGX"),

    /**=========用票-代办退税===========*/
    /**
     * 批量发票代办退税勾选
     */
    INVOICE_DEPUTY_TAX_REFUND_UPLOAD("invoiceDeputyTaxRefundUpload", "PLFPDBGX"),
    /**
     * 查询发票代办退税勾选处理结果
     */
    INVOICE_DEPUTY_TAX_REFUND_UPLOAD_RESULT("invoiceDeputyTaxRefundUploadResult", "CXDBTSGX"),
    /**
     * 未勾选数据初始化清单下载申请-代办退税
     */
    DEPUTY_TAX_REFUND_UNCHECK_INIT("deputyTaxRefundUncheckInit", "WGXSJCSHQDXZSQDBTSGX"),
    /**
     * 未勾选数据初始化清单下载申请反馈-代办退税
     */
    DEPUTY_TAX_REFUND_UNCHECK_INIT_RESULT("deputyTaxRefundUncheckInitResult", "WGXSJCSHQDXZSQFKDBTSGX"),

    /**
     * =========用票-查验===========
     */
    INVOICE_VERIFY("invoiceVerify", "FPCY_NEW"),

    /**
     * =========发票入账===========
     */
    INVOICE_ENTRY_UPLOAD("invoiceEntryUpload", "PLSCRZFP"),
    INVOICE_ENTRY_UPLOAD_RESULT("invoiceEntryUploadResult", "CXFPRZCLJG"),
    VAT_TAX_PAYMENT_VOUCHER_ENTRY_UPLOAD("vatTaxPaymentVoucherEntryUpload", "PLSCRZDKDJWSPZ"),
    VAT_TAX_PAYMENT_VOUCHER_ENTRY_UPLOAD_RESULT("vatTaxPaymentVoucherEntryUploadResult", "CXDKDJWSPZRZCLJG"),
    CUSTOMS_PAYMENT_ENTRY_UPLOAD("customsPaymentEntryUpload", "PLSCRZHGJKS"),
    CUSTOMS_PAYMENT_ENTRY_UPLOAD_RESULT("customsPaymentEntryUploadResult", "CXHGJKSRZCLJG"),

    /**
     * =========实人认证===========
     */
    GET_QR_CODE("getQRCode", "/access/v1/getQRCode"),
    GET_AUTH_CODE("getAuthCode", "/access/v1/getAuthCode"),
    GET_TOKEN("getToken", "/access/v1/getToken"),
    SANDBOX_CONTROL("sandboxControl", "/access/sandbox_kzfw/v1/%s"),

    /**
     * =========使用单位管理能力===========
     */
    /**
     * 查询使用单位乐企白名单开通状态
     */
    USE_UNIT_WHITELIST_OPEN_STATUS("useUnitWhitelistOpenStatus", "CXSYDWLQBMDKTZT"),

    /**
     * 查询开票人员登记确认状态接口
     */
    USE_UNIT_ISSUER_REGIST_STATUS("useUnitIssuerRegistStatus", "CXKPRYDJQRZT"),
    /**
     * 查询使用单位接入状态接口
     */
    USE_UNIT_ACCESS_STATUS("useUnitAccessStatus", "CXSYDWJRZT"),
    /**
     * 查询使用单位授权认证信息
     */
    USE_UNIT_AUTH_INFO("useUnitAuthInfo", "CXSYDWSQRZXX"),
    /**
     * 使用单位申请接口
     */
    USE_UNIT_APPLY("useUnitApply", "SYDWSQ"),

    /**
     * =========监管能力===========
     */
    /**
     * 上传指标扫描结果
     */
    INDEX_UPLOAD("indexUpload", "SCZBSMJG"),
    /**
     * 查询上传结果
     */
    INDEX_UPLOAD_RESULT("indexUploadResult", "CXSCJG"),
    /**
     * 使用单位红色预警检测（单户）
     */
    USE_UNIT_RED_ALERT("useUnitRedAlert", "SYDWHSYJJCDH"),
    /**
     * 使用单位红色预警检测（批量）
     */
    USE_UNIT_RED_ALERT_BATCH("useUnitRedAlertBatch", "SYDWHSYJJCPL"),
    /**
     * 反馈使用单位红色预警检测结果
     */
    USE_UNIT_RED_ALERT_BATCH_RESULT("useUnitRedAlertBatchResult", "FKSYDWHSYJJCJG");

    private final String name;
    private final String serviceCode;

    NaturalSystemEnums(String name, String serviceCode) {
        this.name = name;
        this.serviceCode = serviceCode;
    }

    public static NaturalSystemEnums fromServiceCode(String serviceCode) {
        final var values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(serviceCode, naturalSystemEnums.serviceCode)).findFirst().orElse(null);
    }

    public static NaturalSystemEnums fromServiceName(String name) {
        final var values = NaturalSystemEnums.values();
        return Arrays.stream(values).filter(naturalSystemEnums -> Objects.equals(name, naturalSystemEnums.name)).findFirst().orElse(null);
    }

}
