package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @date 2025/8/25
 * @describe: 查询金银首饰经营企业资格，单个企业信息建议每天查询一次，最多每天不能查询超过三次
 */
public class PostJewelryQualificationMessage {

    @Data
    public static class Request {
        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {

        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;

        /**
         * 是否金银首饰经营企业
         * Y：是
         * N：否
         */
        @JSONField(name = "sfjyssjyqy")
        private String jewelryEnterpriseFlag;

        /**
         * 有效期起 yyyy-MM-dd
         * 是金银首饰经营企业时返回
         */
        @JSONField(name = "yxqq")
        private String startDate;

        /**
         * 有效期止
         * yyyy-MM-dd
         * 是金银首饰经营企业时返回
         */
        @JSONField(name = "yxqz")
        private String endDate;
    }
}

