package com.xforceplus.taxware.leqi.kernel.contract.model.seller;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.taxware.leqi.kernel.contract.model.base.NaturalSystemBody;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lv
 * @date 2023/10/8
 * @describe: 查询成品油库存
 */
public class PostOilInventoryMessage {

    /**
     * 锁定
     */
    public static final String BLOCK = "Y";

    /**
     * 未锁定
     */
    public static final String UNBLOCK = "N";

    @Data
    public static class Request {

        /**
         * 纳税人识别号/统一社会信用代码
         */
        @JSONField(name = "nsrsbh")
        private String taxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ResultData extends NaturalSystemBody.BaseResponseData {


        /**
         * 消费税纳税人类型
         */
        @JSONField(name = "resultList")
        private List<InventoryInfo> inventoryInfos;

        @Data
        public static class InventoryInfo {

            /**
             * 商品名称
             */
            @JSONField(name = "spmc")
            private String itemName;

            /**
             * 商品编码
             */
            @JSONField(name = "spbm")
            private String goodsTaxNo;

            /**
             * 成品油总库存
             * number
             * 16,8
             */
            @JSONField(name = "cpyzkc")
            private BigDecimal total;

            /**
             * 可使用成品油 库存
             * number
             * 16,8
             */
            @JSONField(name = "ksycpykc")
            private BigDecimal remain;

            /**
             * 已下载成品油 库存
             * number
             * 16,8
             */
            @JSONField(name = "yxzcpykc")
            private BigDecimal downloaded;

            /**
             * 已下载未使用 成品油库存
             * number
             * 16,8
             */
            @JSONField(name = "yxzwsycpykc")
            private BigDecimal unUsed;

            /**
             * 锁定标志
             * Y:库存已锁定 N:库存未锁定
             */
            @JSONField(name = "sdbz")
            private String blockStatus;
        }
    }
}
